/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.function.Predicate;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.library.recipe.ModItemList;
import knightminer.inspirations.library.recipe.crafting.ShapelessNoContainerRecipe;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.mantle.util.RetexturedHelper;

public class InspirationsCommons
extends ModuleBase {
    public static ShapelessNoContainerRecipe.Serializer shapelessNoContainer;
    public static LootItemConditionType lootConfig;
    public static final EnumObject<DyeColor, Block> VANILLA_CARPETS;

    @SubscribeEvent
    void register(RegisterEvent event) {
        ResourceKey key = event.getRegistryKey();
        if (key == Registries.f_256764_) {
            shapelessNoContainer = InspirationsCommons.register(ForgeRegistries.RECIPE_SERIALIZERS, "shapeless_no_container", new ShapelessNoContainerRecipe.Serializer());
            CraftingHelper.register((ResourceLocation)Inspirations.getResource("mod_item_list"), (IIngredientSerializer)ModItemList.SERIALIZER);
        } else if (key == Registries.f_256976_) {
            ConfigEnabledCondition.ConditionSerializer confEnabled = new ConfigEnabledCondition.ConditionSerializer();
            CraftingHelper.register((IConditionSerializer)confEnabled);
            lootConfig = InspirationsCommons.register(BuiltInRegistries.f_256991_, "config", new LootItemConditionType((Serializer)confEnabled));
        }
    }

    @SubscribeEvent
    void creativeTabs(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        if (key == CreativeModeTabs.f_256776_) {
            if (Config.enableFlowers.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsBuilding.flower);
            }
            if (Config.smoothBlockCropGrowth.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTweaks.cactusSeeds);
                event.m_246326_((ItemLike)InspirationsTweaks.sugarCaneSeeds);
            }
        } else if (key == CreativeModeTabs.f_256788_) {
            if (Config.enableMulch.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsBuilding.mulch);
            }
            if (Config.enablePath.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsBuilding.path);
            }
            if (Config.enableEnlightenedBush.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsBuilding.enlightenedBush, (TagKey<Item>)ItemTags.f_13143_);
            }
        } else if (key == CreativeModeTabs.f_256791_) {
            if (Config.enableRope.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsBuilding.rope);
                event.m_246326_((ItemLike)InspirationsBuilding.vine);
            }
            if (Config.enableBookshelf.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsBuilding.shelf, (TagKey<Item>)ItemTags.f_13168_);
            }
            if (Config.enableColoredBooks.getAsBoolean()) {
                InspirationsBuilding.coloredBook.addVariants(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246342_(arg_0));
            }
        } else if (key == CreativeModeTabs.f_257028_) {
            if (Config.enableGlassDoor.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsBuilding.glassDoorItem);
                event.m_246326_((ItemLike)InspirationsBuilding.glassTrapdoor);
            }
            if (Config.enableCarpetedTrapdoor.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsUtility.carpetedTrapdoors);
            }
            if (Config.enableTorchLever.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsUtility.torchLeverItem);
                event.m_246326_((ItemLike)InspirationsUtility.soulLeverItem);
            }
            if (Config.enableCollector.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsUtility.collector);
            }
            if (Config.enablePipe.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsUtility.pipe);
            }
            if (Config.enableRedstoneBook.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsBuilding.redstoneBook);
            }
        } else if (key == CreativeModeTabs.f_256839_) {
            if (Config.enableHeartbeet.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTweaks.heartbeet);
            }
            if (Config.enableCauldronSoups.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsCaudrons.potatoSoupItem);
            }
            if (Config.enableMilkBottles.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsCaudrons.milkBottle);
            }
        } else if (key == CreativeModeTabs.f_256968_) {
            if (Config.enableCauldronPotions.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsCaudrons.splashBottle);
                event.m_246326_((ItemLike)InspirationsCaudrons.lingeringBottle);
            }
            if (Config.enableCauldronDyeing.getAsBoolean()) {
                InspirationsCommons.accept(event, InspirationsCaudrons.simpleDyedWaterBottle);
            }
        } else if (key == CreativeModeTabs.f_256869_) {
            if (Config.enableRedstoneCharger.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.redstoneCharger);
                event.m_246326_((ItemLike)InspirationsTools.redstoneArrow);
            }
            if (Config.enableLock.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.lock);
                event.m_246326_((ItemLike)InspirationsTools.key);
            }
            if (Config.enableNorthCompass.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.northCompass);
            }
            if (Config.enableDimensionCompass.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.dimensionCompass);
            }
            if (Config.enableBarometer.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.barometer);
            }
            if (Config.enablePhotometer.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsTools.photometer);
            }
            if (Config.enableCauldronSoups.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsCaudrons.mushroomStewBucket);
                event.m_246326_((ItemLike)InspirationsCaudrons.beetrootSoupBucket);
                event.m_246326_((ItemLike)InspirationsCaudrons.rabbitStewBucket);
                event.m_246326_((ItemLike)InspirationsCaudrons.potatoSoupBucket);
            }
            if (Config.enableCauldronHoney.getAsBoolean()) {
                event.m_246326_((ItemLike)InspirationsCaudrons.honeyBucket);
            }
        }
    }

    private static void accept(BuildCreativeModeTabContentsEvent event, EnumObject<?, ? extends ItemLike> object) {
        object.forEach(item -> event.m_246326_(item));
    }

    private static void accept(BuildCreativeModeTabContentsEvent event, EnumObject<?, ? extends ItemLike> object, TagKey<Item> textures) {
        Predicate<ItemStack> acceptor = stack -> {
            event.m_246342_(stack);
            return (Boolean)Config.showAllVariants.get() == false;
        };
        object.forEach(item -> RetexturedHelper.addTagVariants((Predicate)acceptor, (ItemLike)item, (TagKey)textures));
    }

    static {
        VANILLA_CARPETS = new EnumObject.Builder(DyeColor.class).put((Enum)DyeColor.WHITE, (Object)Blocks.f_50336_).put((Enum)DyeColor.ORANGE, (Object)Blocks.f_50337_).put((Enum)DyeColor.MAGENTA, (Object)Blocks.f_50338_).put((Enum)DyeColor.LIGHT_BLUE, (Object)Blocks.f_50339_).put((Enum)DyeColor.YELLOW, (Object)Blocks.f_50340_).put((Enum)DyeColor.LIME, (Object)Blocks.f_50341_).put((Enum)DyeColor.PINK, (Object)Blocks.f_50342_).put((Enum)DyeColor.GRAY, (Object)Blocks.f_50343_).put((Enum)DyeColor.LIGHT_GRAY, (Object)Blocks.f_50344_).put((Enum)DyeColor.CYAN, (Object)Blocks.f_50345_).put((Enum)DyeColor.PURPLE, (Object)Blocks.f_50346_).put((Enum)DyeColor.BLUE, (Object)Blocks.f_50347_).put((Enum)DyeColor.BROWN, (Object)Blocks.f_50348_).put((Enum)DyeColor.GREEN, (Object)Blocks.f_50349_).put((Enum)DyeColor.RED, (Object)Blocks.f_50350_).put((Enum)DyeColor.BLACK, (Object)Blocks.f_50351_).build();
    }
}

