/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common;

import java.util.function.BooleanSupplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

public class Config {
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final ForgeConfigSpec.BooleanValue buildingModule;
    public static final ForgeConfigSpec.BooleanValue utilityModule;
    public static final ForgeConfigSpec.BooleanValue toolsModule;
    public static final ForgeConfigSpec.BooleanValue tweaksModule;
    public static final ForgeConfigSpec.BooleanValue cauldronsModule;
    public static final ForgeConfigSpec.BooleanValue showAllVariants;
    public static final BooleanSupplier enableRope;
    public static final BooleanSupplier enableRopeLadder;
    public static final BooleanSupplier enableGlassDoor;
    public static final BooleanSupplier enableMulch;
    public static final BooleanSupplier enablePath;
    public static final BooleanSupplier enableFlowers;
    public static final BooleanSupplier enableEnlightenedBush;
    public static final ForgeConfigSpec.BooleanValue climbableIronBars;
    public static final BooleanSupplier enableBookshelf;
    public static final BooleanSupplier enableColoredBooks;
    public static final BooleanSupplier bookshelvesBoostEnchanting;
    public static final ForgeConfigSpec.ConfigValue<Double> defaultEnchantingPower;
    public static final BooleanSupplier enableTorchLever;
    public static final BooleanSupplier enableRedstoneBook;
    public static final BooleanSupplier enableCarpetedTrapdoor;
    public static final BooleanSupplier enableCarpetedPressurePlate;
    public static final BooleanSupplier enableCollector;
    public static final BooleanSupplier enablePipe;
    public static final ForgeConfigSpec.BooleanValue pipeUpwards;
    public static final BooleanSupplier enableMilkBottles;
    public static final BooleanSupplier cauldronConcrete;
    public static final BooleanSupplier cauldronCleanStickyPiston;
    public static final BooleanSupplier cauldronWetSponge;
    public static final BooleanSupplier cauldronWashWool;
    public static final BooleanSupplier replaceVanillaCauldrons;
    public static final BooleanSupplier enableCauldronMilk;
    public static final BooleanSupplier enableCauldronHoney;
    public static final BooleanSupplier enableCauldronSoups;
    public static final BooleanSupplier enableCauldronDyeing;
    public static final BooleanSupplier extraBottleRecipes;
    public static final BooleanSupplier enableCauldronPotions;
    public static final BooleanSupplier brewPotionBottles;
    public static final BooleanSupplier cauldronBrewing;
    public static final BooleanSupplier cauldronTipArrows;
    public static final BooleanSupplier enableLock;
    public static final BooleanSupplier enableRedstoneCharger;
    public static final BooleanSupplier enableChargedArrow;
    public static final BooleanSupplier harvestHangingVines;
    public static final BooleanSupplier shearsReclaimMelons;
    public static final BooleanSupplier enableNorthCompass;
    public static final BooleanSupplier enableBarometer;
    public static final BooleanSupplier enablePhotometer;
    public static final BooleanSupplier enableDimensionCompass;
    public static final BooleanSupplier moreShieldEnchantments;
    public static final BooleanSupplier shieldEnchantmentTable;
    public static final BooleanSupplier fixShieldTooltip;
    public static final BooleanSupplier axeWeaponEnchants;
    public static final BooleanSupplier axeEnchantmentTable;
    public static final BooleanSupplier enablePigDesaddle;
    public static final BooleanSupplier enableFittedCarpets;
    public static final BooleanSupplier lilypadBreakFall;
    public static final BooleanSupplier unstackableRecipeAlts;
    public static final BooleanSupplier dispensersPlaceAnvils;
    public static final ForgeConfigSpec.BooleanValue milkCooldown;
    public static final ForgeConfigSpec.ConfigValue<Integer> milkCooldownTime;
    public static final BooleanSupplier waterlogHopper;
    public static final ForgeConfigSpec.BooleanValue betterCauldronItem;
    public static final ForgeConfigSpec.BooleanValue coloredEnchantedRibbons;
    public static final ForgeConfigSpec.BooleanValue coloredFireworkItems;
    public static final ForgeConfigSpec.BooleanValue customPortalColor;
    public static final BooleanSupplier tintLecternBook;
    public static final BooleanSupplier enableHeartbeet;
    public static final BooleanSupplier brewHeartbeet;
    public static final BooleanSupplier smoothBlockCropGrowth;
    public static final ForgeConfigSpec.BooleanValue bonemealBlockCrop;
    public static final ForgeConfigSpec.BooleanValue nerfCactusFarms;
    public static final BooleanSupplier bonemealMushrooms;
    public static final BooleanSupplier bonemealDeadBush;
    public static final BooleanSupplier bonemealGrassSpread;
    public static final BooleanSupplier bonemealMyceliumSpread;
    public static final BooleanSupplier caveSpiderDrops;
    public static final BooleanSupplier skeletonSkull;
    private static boolean loaded;

    public static boolean isLoaded() {
        return loaded;
    }

    public static void configChanged(ModConfigEvent configEvent) {
        IConfigSpec spec;
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals("inspirations") && (spec = config.getSpec()) == SERVER_SPEC) {
            loaded = true;
        }
    }

    private static BooleanSupplier and(ForgeConfigSpec.BooleanValue first, ForgeConfigSpec.BooleanValue second) {
        return () -> (Boolean)first.get() != false && (Boolean)second.get() != false;
    }

    private static BooleanSupplier and(BooleanSupplier first, ForgeConfigSpec.BooleanValue second) {
        return () -> first.getAsBoolean() && (Boolean)second.get() != false;
    }

    private static BooleanSupplier and(BooleanSupplier first, BooleanSupplier second) {
        return () -> first.getAsBoolean() && second.getAsBoolean();
    }

    private static BooleanSupplier and(ForgeConfigSpec.BooleanValue first, ForgeConfigSpec.BooleanValue second, ForgeConfigSpec.BooleanValue third) {
        return () -> (Boolean)first.get() != false && (Boolean)second.get() != false && (Boolean)third.get() != false;
    }

    private static BooleanSupplier and(BooleanSupplier first, ForgeConfigSpec.BooleanValue second, ForgeConfigSpec.BooleanValue third) {
        return () -> first.getAsBoolean() && (Boolean)second.get() != false && (Boolean)third.get() != false;
    }

    static {
        ForgeConfigSpec.Builder server = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder client = new ForgeConfigSpec.Builder();
        ForgeConfigSpec.Builder common = new ForgeConfigSpec.Builder();
        common.push("modules");
        buildingModule = common.comment("Building blocks to improve decoration").worldRestart().define("building", true);
        utilityModule = common.comment("Adds tools for automation and redstone interaction").worldRestart().define("utility", true);
        tweaksModule = common.comment("Contains tweaks to vanilla features").worldRestart().define("tweaks", true);
        toolsModule = common.comment("Includes new tools to reduce dependency on debug features").worldRestart().define("tools", true);
        cauldronsModule = common.comment("Expands interactions available to the cauldron and adds new variants").worldRestart().define("cauldrons", true);
        common.pop();
        showAllVariants = server.comment("Shows all variants for dynamically textured blocks, like bookshelves. If false just the first will be shown").define("general.showAllVariants", true);
        common.push("building");
        server.push("building");
        enableBookshelf = Config.and(buildingModule, common.comment("Enables the shelf: a decorative block to display books and other items").worldRestart().define("bookshelf.enable", true));
        enableColoredBooks = Config.and(enableBookshelf, common.comment("Enables colored books: basically colored versions of the vanilla book to decorate shelves").worldRestart().define("bookshelf", true));
        bookshelvesBoostEnchanting = Config.and(buildingModule, server.comment("If true, shelves will increase enchanting table power.").define("bookshelf.boostEnchanting", true));
        defaultEnchantingPower = server.comment("Default power for a book for enchanting, can be overridden in the book overrides.").defineInRange("bookshelf.defaultEnchanting", 1.5, 0.0, 15.0);
        enableRope = Config.and(buildingModule, common.comment("Enables rope: can be climbed like ladders and extended with additional rope").worldRestart().define("rope", true));
        enableRopeLadder = Config.and(enableRope, server.comment("Enables rope ladders: right click ropes with sticks to extend the hitbox").define("ropeLadder", true));
        climbableIronBars = common.comment("Makes iron bars climbable if a rope is below them, requires block override on minecraft:iron_bars.").worldRestart().define("climbableBars", true);
        enableGlassDoor = Config.and(buildingModule, common.comment("Enables glass doors and trapdoors: basically doors, but made of glass. Not sure what you would expect.").worldRestart().define("glassDoor", true));
        enableMulch = Config.and(buildingModule, common.comment("Enables mulch: a craftable falling block which supports plants such as flowers").worldRestart().define("mulch", true));
        enablePath = Config.and(buildingModule, common.comment("Enables stone paths: a carpet like decorative block for making decorative paths").worldRestart().define("path", true));
        enableFlowers = Config.and(buildingModule, common.comment("Enables additional flowers from breaking double flowers with shears.").worldRestart().define("flowers", true));
        enableEnlightenedBush = Config.and(buildingModule, common.comment("Enables enlightened bushes: bushes with lights.").worldRestart().define("enlightenedBush", true));
        common.pop();
        server.pop();
        server.push("utility");
        common.push("utility");
        enableRedstoneBook = Config.and(enableBookshelf, utilityModule, common.comment("Enables the trapped book: will emit redstone power when placed in a bookshelf. Requires bookshelf.").worldRestart().define("redstoneBook", true));
        enableTorchLever = Config.and(utilityModule, common.comment("Enables the torch lever: basically a lever which looks like a torch").worldRestart().define("torchLever", true));
        enableCarpetedTrapdoor = Config.and(utilityModule, common.comment("Enables carpeted trapdoors: a trapdoor which appears to be a carpet when closed").worldRestart().define("carpetedTrapdoor", true));
        enableCarpetedPressurePlate = Config.and(utilityModule, server.comment("Allows placing a carpet on a stone pressure plate to hide it").define("carpetedPressurePlate", true));
        enableCollector = Config.and(utilityModule, common.comment("Enables the collector: extracts items from inventories or the world similar to a hopper, but can face in all 6 directions and cannot place items in inventories").worldRestart().define("collector", true));
        enablePipe = Config.and(utilityModule, common.comment("Enables pipes: a more economical hopper that only outputs items, does not pull from inventories. Both cheaper and better for performance.").worldRestart().define("pipe", true));
        pipeUpwards = server.comment("Allows pipes to output upwards. This removes a limitation on not being able to pipe items up without dropper elevators, but should be balanced alongside modded pipes.").define("pipeUpwards", true);
        server.pop();
        common.pop();
        common.push("cauldron");
        enableMilkBottles = Config.and(cauldronsModule, common.comment("Allows filling glass bottles with milk from a cow. Note moving milk from bucket to bottles requires milk cauldrons").define("milkBottles", true));
        replaceVanillaCauldrons = Config.and(cauldronsModule, common.comment("If true, improves vanilla water cauldrons by including boiling particles, requires a block substitution on water cauldrons. More functionality coming to this option later.").worldRestart().define("replaceWaterCauldron", true));
        common.push("vanilla");
        cauldronConcrete = Config.and(cauldronsModule, common.comment("Allows concrete to be made a cauldron filled with water").worldRestart().define("concrete", true));
        cauldronCleanStickyPiston = Config.and(cauldronsModule, common.comment("Lets you clean sticky pistons in the cauldron").worldRestart().define("cleanStickyPiston", true));
        cauldronWetSponge = Config.and(cauldronsModule, common.comment("Lets you wet sponges in the cauldron").worldRestart().define("wetSponge", true));
        cauldronWashWool = Config.and(cauldronsModule, common.comment("Lets you wash various wool created items in a water filled cauldron to turn it white").worldRestart().define("washWool", true));
        common.pop();
        common.push("contents");
        enableCauldronMilk = Config.and(cauldronsModule, common.comment("Allows the cauldron to be filled with milk").define("milk", true));
        enableCauldronHoney = Config.and(cauldronsModule, common.comment("Allows the cauldron to be filled with honey").define("honey", true));
        enableCauldronSoups = Config.and(cauldronsModule, common.comment("Allows the cauldron to be filled with soups, including mushroom, potato, rabbit, suspicious, and beetroot").define("soup", true));
        common.pop();
        common.push("dyes");
        enableCauldronDyeing = Config.and(cauldronsModule, common.comment("Allows cauldrons to be filled with dyes and dye items using cauldrons").define("enable", true));
        extraBottleRecipes = Config.and(enableCauldronDyeing, common.comment("Adds extra dyed bottle recipes to craft green and brown").define("extraBottleRecipes", true));
        common.pop();
        common.push("potions");
        enableCauldronPotions = Config.and(cauldronsModule, common.comment("Allows cauldrons to be filled with potions").define("enable", true));
        brewPotionBottles = Config.and(enableCauldronPotions, common.comment("Allows brewing glass bottles into splash and lingering bottles in a brewing stand").define("brewBottles", true));
        cauldronTipArrows = Config.and(enableCauldronPotions, common.comment("Allows cauldrons to tip arrows with potions").define("tipArrows", true));
        cauldronBrewing = Config.and(enableCauldronPotions, common.comment("Allows cauldrons to perform brewing recipes").define("brewing", true));
        common.pop();
        common.pop();
        server.push("tools");
        common.push("tools");
        enableRedstoneCharger = Config.and(toolsModule, common.comment("Enables the redstone charger: a quick pulse created with a flint and steel like item").worldRestart().define("redstoneCharger", true));
        enableChargedArrow = Config.and(toolsModule, common.comment("Enables the charged arrow: places a redstone pulse where it lands").worldRestart().define("chargedArrow", true));
        enableLock = Config.and(toolsModule, common.comment("Enables locks and keys: an item allowing you to lock a tile entity to only open for a special named item").worldRestart().define("lock", true));
        harvestHangingVines = Config.and(toolsModule, server.comment("When shearing vines, any supported vines will also be sheared instead of just broken").define("harvestHangingVines", true));
        shearsReclaimMelons = Config.and(toolsModule, server.comment("Breaking a melon block with shears will always return 9 slices").define("reclaimMelons", true));
        enableNorthCompass = Config.and(toolsModule, common.comment("Enables the north compass: a cheaper compass that always points north. Intended to either allow packs to replace the compass or as an alternative for F3 navigation").worldRestart().define("northCompass", true));
        enableBarometer = Config.and(toolsModule, common.comment("Enables the barometer: a tool to measure the player's height in world.").worldRestart().define("barometer", true));
        enablePhotometer = Config.and(toolsModule, common.comment("Enables the photometer: a tool to measure light in world. Can be pointed at a block to measure the light level of that block.").worldRestart().define("photometer", true));
        enableDimensionCompass = Config.and(toolsModule, common.comment(new String[]{"Enables the dimension compass: a compass which points towards the place you entered a dimension.", "When used on a lodestone, works across dimensions taking nether coordinates into account"}).worldRestart().define("dimensionCompass", true));
        fixShieldTooltip = Config.and(toolsModule, server.comment("If true, fixes the tooltip on shield items so it looks better with both patterns and enchantments").worldRestart().define("fixShieldTooltip", true));
        common.push("enchantments");
        moreShieldEnchantments = Config.and(toolsModule, common.comment("If true, shields can now be enchanted with enchantments such as protection, fire aspect, knockback, and thorns. This requires replacing these enchantments.").worldRestart().define("moreShield", true));
        shieldEnchantmentTable = Config.and(moreShieldEnchantments, common.comment("If true, shields can be enchanted in an enchantment table. Does not support modded shields as it requires a registry substitution").worldRestart().define("shieldTable", true));
        axeWeaponEnchants = Config.and(toolsModule, common.comment("If true, axes will be able to be enchanted with weapon enchants such as looting, fire aspect, and knockback").worldRestart().define("axeWeapon", true));
        axeEnchantmentTable = Config.and(toolsModule, common.comment("If true, axes can receive available weapon enchantments at the enchantment table").worldRestart().define("axeTable", true));
        common.pop();
        common.pop();
        server.pop();
        server.push("tweaks");
        common.push("tweaks");
        enablePigDesaddle = Config.and(tweaksModule, server.comment("Allows pigs to be desaddled by shift-right click with an empty hand").define("desaddlePig", true));
        enableFittedCarpets = Config.and(tweaksModule, common.comment("Replace carpet blocks, allowing them to fit to stairs below them. Requires a registry sub on all vanilla carpet blocks.").worldRestart().define("fittedCarpets", true));
        waterlogHopper = Config.and(tweaksModule, common.comment("Replace hopper blocks, allowing them to be waterlogged. Requires a registry sub on hoppers").worldRestart().define("waterlogHoppers", true));
        tintLecternBook = Config.and(tweaksModule, common.comment("If true, tints the color of the lectern book based on the color of the contained item").worldRestart().define("tintLecternBook", true));
        server.push("bonemeal");
        bonemealMushrooms = Config.and(tweaksModule, server.comment("Bonemeal can be used on mycelium to produce mushrooms").define("mushrooms", true));
        bonemealDeadBush = Config.and(tweaksModule, server.comment("Bonemeal can be used on sand to produce dead bushes").define("deadBush", true));
        bonemealGrassSpread = Config.and(tweaksModule, server.comment("Bonemeal can be used on dirt to produce grass if adjecent to grass").define("grassSpread", true));
        bonemealMyceliumSpread = Config.and(tweaksModule, server.comment("Bonemeal can be used on dirt to produce mycelium if adjecent to mycelium").define("myceliumSpread", true));
        server.pop();
        server.push("heartbeet");
        enableHeartbeet = Config.and(tweaksModule, server.comment("Enables heartbeets: a rare drop from beetroots which can be eaten to restore a bit of health").worldRestart().define("enable", true));
        brewHeartbeet = Config.and(enableHeartbeet, server.comment("Allows heartbeets to be used as an alternative to ghast tears in making potions of regeneration").worldRestart().define("brewRegeneration", true));
        server.pop();
        dispensersPlaceAnvils = Config.and(tweaksModule, server.comment("Dispensers will place anvils instead of dropping them. Plays well with anvil smashing.").worldRestart().define("dispensersPlaceAnvils", true));
        lilypadBreakFall = Config.and(tweaksModule, server.comment("Lily pads prevent fall damage, but break in the process").define("lilypadBreakFall", true));
        unstackableRecipeAlts = Config.and(tweaksModule, common.comment("Adds stackable recipes to some vanilla or Inspriations items that require unstackable items to craft").worldRestart().define("unstackableRecipeAlts", true));
        caveSpiderDrops = Config.and(tweaksModule, server.comment("If true, cave spiders will rarely drop webs, giving them an advantage to farm over regular spiders").define("caveSpiderWeb", true));
        skeletonSkull = Config.and(tweaksModule, server.comment("If true, skeletons will rarely drop their skull for consistency with wither skeletons. Does not affect creeper or zombie heads.").define("skeletonSkull", true));
        server.push("milkCooldown");
        milkCooldown = server.comment("Adds a cooldown to milking cows, prevents practically infinite milk in modded worlds where milk is more useful.").define("enable", false);
        milkCooldownTime = server.comment("Delay in seconds after milking a cow before it can be milked again.").defineInRange("time", 600, 1, Short.MAX_VALUE);
        server.pop();
        server.push("smoothGrowth");
        smoothBlockCropGrowth = Config.and(tweaksModule, server.comment("If true, cactus and sugar cane will grow in 2 pixel increments using the block crops").define("enable", true));
        bonemealBlockCrop = server.comment("If true, allows bonemeal to be used to speed block crop growth").define("bonemeal", false);
        nerfCactusFarms = server.comment(new String[]{"If false, cactus seeds planted on cactus have fewer restrictions.", "Setting to true means cactus seeds are broken by neighboring blocks, meaning classic cactus farms will drop cactus seeds instead of full cactus."}).define("nerfCactusFarms", false);
        server.pop();
        server.pop();
        common.pop();
        client.push("general");
        betterCauldronItem = client.comment("Replaces the flat cauldron sprite with the 3D cauldron block model").define("betterCauldronItemModel", true);
        coloredFireworkItems = client.comment("Colors the fireworks item based on the colors of the stars").worldRestart().define("coloredFireworkItems", true);
        coloredEnchantedRibbons = client.comment("The ribbon on enchanted books colors based on the enchantment rarity").worldRestart().define("coloredEnchantedRibbons", true);
        customPortalColor = client.comment("Allows the portal color to be changed by placing colored blocks under the portal. Any block that tints a beacon beam will work for the color.").worldRestart().define("customPortalColor", true);
        client.pop();
        SERVER_SPEC = server.build();
        CLIENT_SPEC = client.build();
        COMMON_SPEC = common.build();
        loaded = false;
    }
}

