/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.Optional;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.building.block.type.BushType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.building.client.ShelfBlockEntityRenderer;
import knightminer.inspirations.building.client.ShelfContainerScreen;
import knightminer.inspirations.common.AbstractClientEvents;
import knightminer.inspirations.library.MiscUtil;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.library.client.model.ShelfModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.util.BlockEntityHelper;
import slimeknights.mantle.util.RetexturedHelper;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class BuildingClientEvents
extends AbstractClientEvents {
    private static final Minecraft mc = Minecraft.m_91087_();

    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        if (InspirationsBuilding.ironBars != null) {
            ItemBlockRenderTypes.setRenderLayer((Block)InspirationsBuilding.ironBars, (RenderType)RenderType.m_110457_());
        }
    }

    @SubscribeEvent
    static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(InspirationsBuilding.shelfTileEntity, ShelfBlockEntityRenderer::new);
    }

    @SubscribeEvent
    static void registerModelLoaders(ModelEvent.RegisterGeometryLoaders event) {
        event.register("shelf", ShelfModel.LOADER);
    }

    @SubscribeEvent
    static void commonSetup(FMLCommonSetupEvent event) {
        BuildingClientEvents.registerScreenFactory(InspirationsBuilding.shelfContainer, ShelfContainerScreen::new);
    }

    @SubscribeEvent
    static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            ItemStack stack;
            BlockEntity te;
            if (tintIndex > 0 && tintIndex <= 16 && world != null && pos != null && (te = world.m_7702_(pos)) instanceof ShelfBlockEntity && !(stack = ((ShelfBlockEntity)te).getInventory().getStackInSlot(tintIndex - 1)).m_41619_()) {
                int color = ClientUtil.getItemColor(stack.m_41720_());
                int itemColors = mc.getItemColors().m_92676_(stack, 0);
                if (itemColors > -1) {
                    color = MiscUtil.combineColors(color, itemColors, 3);
                }
                return color;
            }
            return -1;
        }, (Block)InspirationsBuilding.shelf.getOrNull((Enum)ShelfType.NORMAL));
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            if (world != null && pos != null) {
                return BiomeColors.m_108804_((BlockAndTintGetter)world, (BlockPos)pos);
            }
            return FoliageColor.m_46113_();
        }, InspirationsBuilding.vine);
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            if (type != BushType.WHITE) {
                int color = type.getColor();
                event.register((state, world, pos, tintIndex) -> tintIndex == 0 ? color : -1, new Block[]{bush});
            }
        });
        BuildingClientEvents.registerBlockColors(blockColors, (state, world, pos, tintIndex) -> {
            Block block;
            if (tintIndex != 0 || world == null || pos == null) {
                return -1;
            }
            Optional te = BlockEntityHelper.get(IRetexturedBlockEntity.class, (BlockGetter)world, (BlockPos)pos);
            if (te.isPresent() && (block = ((IRetexturedBlockEntity)te.get()).getTexture()) != Blocks.f_50016_) {
                return ClientUtil.getStackBlockColorsSafe(new ItemStack((ItemLike)block), world, pos, 0);
            }
            return FoliageColor.m_46113_();
        }, (Block)InspirationsBuilding.enlightenedBush.getOrNull((Enum)BushType.WHITE));
    }

    @SubscribeEvent
    static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex > 0 && tintIndex <= 16) {
                return 6638359;
            }
            return -1;
        }, (ItemLike)InspirationsBuilding.shelf.getOrNull((Enum)ShelfType.NORMAL));
        event.register((stack, index) -> index == 0 ? ((DyeableLeatherItem)stack.m_41720_()).m_41121_(stack) : -1, new ItemLike[]{InspirationsBuilding.coloredBook});
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            if (type != BushType.WHITE) {
                int color = type.getColor();
                event.register((stack, tintIndex) -> tintIndex == 0 ? color : -1, new ItemLike[]{bush});
            }
        });
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex != 0) {
                return -1;
            }
            Block block = RetexturedHelper.getTexture((ItemStack)stack);
            if (block != Blocks.f_50016_) {
                return itemColors.m_92676_(new ItemStack((ItemLike)block), 0);
            }
            return FoliageColor.m_46113_();
        }, (ItemLike)InspirationsBuilding.enlightenedBush.getOrNull((Enum)BushType.WHITE));
        BuildingClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> FoliageColor.m_46113_(), new ItemLike[]{InspirationsBuilding.vine});
    }
}

