/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.dispenser;

import java.util.Objects;
import java.util.Optional;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class DispenseFluidTank
extends DefaultDispenseItemBehavior {
    private static final DefaultDispenseItemBehavior DEFAULT = new DefaultDispenseItemBehavior();
    private final DispenseItemBehavior fallback;

    public DispenseFluidTank(DispenseItemBehavior fallback) {
        this.fallback = fallback;
    }

    protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
        if (!stack.m_204117_(InspirationsTags.Items.DISP_FLUID_TANKS)) {
            return this.fallback.m_6115_(source, stack);
        }
        Direction side = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
        BlockPos pos = source.m_7961_().m_121945_(side);
        ServerLevel world = source.m_7727_();
        return FluidUtil.getFluidHandler((Level)world, (BlockPos)pos, (Direction)side.m_122424_()).map(arg_0 -> DispenseFluidTank.lambda$execute$2(stack, (Level)world, pos, source, arg_0)).orElseGet(() -> this.fallback.m_6115_(source, stack));
    }

    private static /* synthetic */ ItemStack lambda$execute$2(ItemStack stack, Level world, BlockPos pos, BlockSource source, IFluidHandler handler) {
        Optional optFluid = FluidUtil.getFluidContained((ItemStack)stack);
        FluidActionResult result = optFluid.isPresent() ? FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true) : FluidUtil.tryFillContainer((ItemStack)stack, (IFluidHandler)handler, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (result.isSuccess()) {
            ItemStack resultStack = result.getResult();
            SoundEvent sound = optFluid.map(fluid -> Objects.requireNonNullElse(fluid.getFluid().getFluidType().getSound(fluid, SoundActions.BUCKET_EMPTY), SoundEvents.f_11778_)).orElseGet(() -> {
                FluidStack resultFluid = (FluidStack)FluidUtil.getFluidContained((ItemStack)resultStack).orElseThrow(AssertionError::new);
                return Objects.requireNonNullElse(resultFluid.getFluid().getFluidType().getSound(resultFluid, SoundActions.BUCKET_FILL), SoundEvents.f_11781_);
            });
            world.m_5594_(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (stack.m_41613_() == 1) {
                return resultStack;
            }
            if (!resultStack.m_41619_() && ((DispenserBlockEntity)source.m_8118_()).m_59237_(resultStack) < 0) {
                DEFAULT.m_6115_(source, resultStack);
            }
            ItemStack shrink = stack.m_41777_();
            shrink.m_41774_(1);
            return shrink;
        }
        return DEFAULT.m_6115_(source, stack);
    }
}

