/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.library.MiscUtil;
import knightminer.inspirations.library.client.ClientUtil;
import knightminer.inspirations.tweaks.network.RequestLecternBookPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.EnchantTableRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TintedLecternRenderer
implements BlockEntityRenderer<LecternBlockEntity> {
    private static final String TAG_REQUESTED = "inspirations_requested";
    public static final Material BOOK_LOCATION = new Material(InventoryMenu.f_39692_, Inspirations.getResource("entity/lectern_book"));
    private final Minecraft mc = Minecraft.m_91087_();
    private final ModelPart book;
    private final ModelPart leftLid;
    private final ModelPart rightLid;
    private final ModelPart seam;

    public TintedLecternRenderer(BlockEntityRendererProvider.Context pContext) {
        this.book = pContext.m_173582_(ModelLayers.f_171271_);
        this.leftLid = this.book.m_171324_("left_lid");
        this.rightLid = this.book.m_171324_("right_lid");
        this.seam = this.book.m_171324_("seam");
        new BookModel(this.book).m_102292_(0.0f, 0.1f, 0.9f, 1.2f);
    }

    public void render(LecternBlockEntity lectern, float pPartialTick, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockState state = lectern.m_58900_();
        if (((Boolean)state.m_61143_((Property)LecternBlock.f_54467_)).booleanValue()) {
            VertexConsumer vertexConsumer;
            ItemStack book;
            poseStack.m_85836_();
            poseStack.m_252880_(0.5f, 1.0625f, 0.5f);
            float rotation = ((Direction)state.m_61143_((Property)LecternBlock.f_54465_)).m_122427_().m_122435_();
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-rotation));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(67.5f));
            poseStack.m_252880_(0.0f, -0.125f, 0.0f);
            this.leftLid.f_104207_ = true;
            this.rightLid.f_104207_ = true;
            this.seam.f_104207_ = true;
            CompoundTag persistent = lectern.getPersistentData();
            if (!persistent.m_128471_(TAG_REQUESTED)) {
                persistent.m_128379_(TAG_REQUESTED, true);
                InspirationsNetwork.INSTANCE.sendToServer(new RequestLecternBookPacket(lectern.m_58899_()));
            }
            if (!((book = lectern.m_59566_()).m_41619_() || book.m_150930_(Items.f_42615_) || book.m_150930_(Items.f_42614_))) {
                vertexConsumer = BOOK_LOCATION.m_119194_(pBuffer, RenderType::m_110446_);
                int color = ClientUtil.getItemColor(book.m_41720_());
                int itemColors = this.mc.getItemColors().m_92676_(book, 0);
                if (color != -1 || itemColors != -1) {
                    if (itemColors != -1) {
                        color = MiscUtil.combineColors(color, itemColors, 3);
                    }
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    this.leftLid.m_104306_(poseStack, vertexConsumer, pPackedLight, pPackedOverlay, r, g, b, 1.0f);
                    this.rightLid.m_104306_(poseStack, vertexConsumer, pPackedLight, pPackedOverlay, r, g, b, 1.0f);
                    this.seam.m_104306_(poseStack, vertexConsumer, pPackedLight, pPackedOverlay, r, g, b, 1.0f);
                    this.leftLid.f_104207_ = false;
                    this.rightLid.f_104207_ = false;
                    this.seam.f_104207_ = false;
                    this.book.m_104306_(poseStack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    poseStack.m_85849_();
                    return;
                }
            }
            vertexConsumer = EnchantTableRenderer.f_112405_.m_119194_(pBuffer, RenderType::m_110446_);
            this.book.m_104306_(poseStack, vertexConsumer, pPackedLight, pPackedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        } else {
            lectern.getPersistentData().m_128473_(TAG_REQUESTED);
        }
    }
}

