/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.tools.ToolsEvents;
import knightminer.inspirations.tools.block.RedstoneChargeBlock;
import knightminer.inspirations.tools.capability.DimensionCompass;
import knightminer.inspirations.tools.datagen.ToolsRecipeProvider;
import knightminer.inspirations.tools.enchantment.AxeDamageEnchantment;
import knightminer.inspirations.tools.enchantment.AxeLootBonusEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedFireAspectEnchantment;
import knightminer.inspirations.tools.enchantment.ExtendedKnockbackEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldProtectionEnchantment;
import knightminer.inspirations.tools.enchantment.ShieldThornsEnchantment;
import knightminer.inspirations.tools.entity.RedstoneArrow;
import knightminer.inspirations.tools.item.DimensionCompassItem;
import knightminer.inspirations.tools.item.EnchantableShieldItem;
import knightminer.inspirations.tools.item.RedstoneArrowItem;
import knightminer.inspirations.tools.item.RedstoneChargerItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.EntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;

public class InspirationsTools
extends ModuleBase {
    public static Item lock;
    public static Item key;
    public static Item redstoneCharger;
    public static Item northCompass;
    public static Item barometer;
    public static Item photometer;
    public static ArrowItem redstoneArrow;
    static Item shield;
    public static Item dimensionCompass;
    public static Block redstoneCharge;
    public static EntityType<RedstoneArrow> entRSArrow;

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register(ToolsEvents.class);
        DimensionCompass.register();
        this.registerDispenserBehavior();
    }

    @SubscribeEvent
    public void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey == Registries.f_256747_) {
            BlockRegistryAdapter registry = new BlockRegistryAdapter(ForgeRegistries.BLOCKS);
            redstoneCharge = (Block)registry.register((Object)new RedstoneChargeBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_278166_(PushReaction.DESTROY).m_60978_(0.0f).m_60953_(state -> 2)), "redstone_charge");
        } else if (registryKey == Registries.f_256913_) {
            ItemRegistryAdapter registry = new ItemRegistryAdapter(ForgeRegistries.ITEMS);
            Item.Properties props = new Item.Properties();
            redstoneArrow = (ArrowItem)registry.register((Object)new RedstoneArrowItem(props), "charged_arrow");
            redstoneCharger = (Item)registry.register((Object)new RedstoneChargerItem(new Item.Properties().m_41503_(120)), "redstone_charger");
            lock = registry.register(props, "lock");
            key = registry.register(props, "key");
            northCompass = registry.register(props, "north_compass");
            barometer = registry.register(props, "barometer");
            photometer = registry.register(props, "photometer");
            dimensionCompass = (Item)registry.register((Object)new DimensionCompassItem(props), "dimension_compass");
            if (Config.shieldEnchantmentTable.getAsBoolean()) {
                shield = (Item)registry.register((Object)new EnchantableShieldItem(new Item.Properties().m_41503_(Items.f_42740_.m_41462_())), (Object)Items.f_42740_);
            }
        } else if (registryKey == Registries.f_256939_) {
            EntityTypeRegistryAdapter registry = new EntityTypeRegistryAdapter(ForgeRegistries.ENTITY_TYPES);
            entRSArrow = registry.register(EntityType.Builder.m_20704_(RedstoneArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).setTrackingRange(4).setUpdateInterval(20).setCustomClientFactory((packet, world) -> new RedstoneArrow(entRSArrow, (Level)world)), "redstone_arrow");
        } else if (registryKey == Registries.f_256762_) {
            EquipmentSlot[] slots;
            RegistryAdapter registry = new RegistryAdapter(ForgeRegistries.ENCHANTMENTS);
            if (Config.moreShieldEnchantments.getAsBoolean()) {
                slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
                for (ProtectionEnchantment ench : new ProtectionEnchantment[]{(ProtectionEnchantment)Enchantments.f_44965_, (ProtectionEnchantment)Enchantments.f_44966_, (ProtectionEnchantment)Enchantments.f_44969_, (ProtectionEnchantment)Enchantments.f_44968_}) {
                    registry.register((Object)new ShieldProtectionEnchantment(ench.m_44699_(), ench.f_45124_, slots), (Object)ench);
                }
                registry.register((Object)new ShieldThornsEnchantment(Enchantments.f_44972_.m_44699_(), slots), (Object)Enchantments.f_44972_);
            }
            if (Config.moreShieldEnchantments.getAsBoolean() || Config.axeWeaponEnchants.getAsBoolean()) {
                slots = new EquipmentSlot[]{EquipmentSlot.MAINHAND};
                registry.register((Object)new ExtendedKnockbackEnchantment(Enchantment.Rarity.UNCOMMON, slots), (Object)Enchantments.f_44980_);
                registry.register((Object)new ExtendedFireAspectEnchantment(Enchantment.Rarity.RARE, slots), (Object)Enchantments.f_44981_);
                if (Config.axeWeaponEnchants.getAsBoolean()) {
                    registry.register((Object)new AxeLootBonusEnchantment(Enchantment.Rarity.RARE, EnchantmentCategory.WEAPON, slots), (Object)Enchantments.f_44982_);
                }
            }
            if (Config.axeEnchantmentTable.getAsBoolean()) {
                slots = new EquipmentSlot[]{EquipmentSlot.MAINHAND};
                registry.register((Object)new AxeDamageEnchantment(Enchantment.Rarity.COMMON, 0, slots), (Object)Enchantments.f_44977_);
                registry.register((Object)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 1, slots), (Object)Enchantments.f_44978_);
                registry.register((Object)new AxeDamageEnchantment(Enchantment.Rarity.UNCOMMON, 2, slots), (Object)Enchantments.f_44979_);
            }
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeServer(), (DataProvider)new ToolsRecipeProvider(gen.getPackOutput()));
    }

    private void registerDispenserBehavior() {
        DispenserBlock.m_52672_((ItemLike)redstoneArrow, (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

            protected Projectile m_6895_(Level world, Position position, ItemStack stack) {
                RedstoneArrow arrow = new RedstoneArrow(world, position.m_7096_(), position.m_7098_(), position.m_7094_());
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.m_52672_((ItemLike)redstoneCharger, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                this.m_123573_(true);
                ServerLevel world = source.m_7727_();
                Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos pos = source.m_7961_().m_121945_(facing);
                if (world.m_8055_(pos).m_60629_((BlockPlaceContext)new DirectionalPlaceContext((Level)world, pos, facing, ItemStack.f_41583_, facing))) {
                    world.m_46597_(pos, (BlockState)redstoneCharge.m_49966_().m_61124_((Property)RedstoneChargeBlock.FACING, (Comparable)facing));
                    if (stack.m_220157_(1, world.f_46441_, null)) {
                        stack.m_41764_(0);
                    }
                } else {
                    this.m_123573_(false);
                }
                return stack;
            }
        });
    }
}

