/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.recipe.cauldron;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import slimeknights.mantle.util.RegistryHelper;

public class CauldronRegistry {
    private static final List<CauldronOverride> CAULDRON_OVERRIDES = new ArrayList<CauldronOverride>();
    public static final Predicate<Block> ALL_CAULDRONS = block -> true;
    public static final Predicate<Item> ALL_ITEMS = block -> true;

    public static void register(Predicate<Block> blockPredicate, Predicate<Item> itemPredicate, CauldronInteraction interaction) {
        CAULDRON_OVERRIDES.add(new CauldronOverride(blockPredicate, itemPredicate, interaction));
    }

    public static InteractionResult attemptOverride(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack stack) {
        Block block = state.m_60734_();
        Item item = stack.m_41720_();
        for (CauldronOverride override : CAULDRON_OVERRIDES) {
            InteractionResult result;
            if (!override.matches(block, item) || !(result = override.interaction().m_175710_(state, level, pos, player, hand, stack)).m_19077_()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    public static Predicate<Item> fluidTag(TagKey<Fluid> fluid) {
        return item -> {
            BucketItem bucket;
            return item instanceof BucketItem && (bucket = (BucketItem)item).getFluid().m_205067_(fluid);
        };
    }

    public static Predicate<Item> itemTag(TagKey<Item> tag) {
        return item -> RegistryHelper.contains((TagKey)tag, (Item)item);
    }

    public static Predicate<Block> exactBlock(Block check) {
        return block -> block == check;
    }

    private record CauldronOverride(Predicate<Block> blockPredicate, Predicate<Item> itemPredicate, CauldronInteraction interaction) {
        public boolean matches(Block block, Item item) {
            return this.blockPredicate.test(block) && this.itemPredicate.test(item);
        }
    }
}

