/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import javax.annotation.Nullable;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.common.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="inspirations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BuildingEvents {
    @SubscribeEvent
    static void toggleRopeLadder(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (!Config.enableRopeLadder.getAsBoolean() || event.getLevel().m_5776_()) {
            return;
        }
        Level world = event.getLevel();
        BlockState state = world.m_8055_(pos = event.getPos());
        if (!(state.m_60734_() instanceof RopeBlock)) {
            return;
        }
        Player player = event.getEntity();
        if (state.m_61143_(RopeBlock.RUNGS) != RopeBlock.Rungs.NONE) {
            if (BuildingEvents.removeRopeLadder(world, pos, state, player)) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
            return;
        }
        if (BuildingEvents.makeRopeLadder(world, pos, state, event.getFace(), player, event.getItemStack())) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    private static boolean removeRopeLadder(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_6047_()) {
            return false;
        }
        world.m_46597_(pos, (BlockState)state.m_61124_(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.NONE)));
        RopeBlock rope = (RopeBlock)state.m_60734_();
        SoundType soundtype = rope.getSoundType(state, (LevelReader)world, pos, (Entity)player);
        world.m_5594_(player, pos, soundtype.m_56775_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)rope.getRungsItem(), 4), (int)player.m_150109_().f_35977_);
        player.m_5810_();
        return true;
    }

    private static boolean makeRopeLadder(Level world, BlockPos pos, BlockState state, @Nullable Direction side, Player player, ItemStack stack) {
        if (side == null || side.m_122434_() == Direction.Axis.Y || stack.m_41613_() < 4 && !player.m_7500_()) {
            return false;
        }
        RopeBlock rope = (RopeBlock)state.m_60734_();
        if (stack.m_41720_() != rope.getRungsItem()) {
            return false;
        }
        world.m_46597_(pos, (BlockState)state.m_61124_(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.fromAxis(side.m_122427_().m_122434_()))));
        SoundType soundtype = state.m_60734_().getSoundType(state, (LevelReader)world, pos, (Entity)player);
        world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
        if (!player.m_7500_()) {
            stack.m_41774_(4);
        }
        return true;
    }
}

