/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block.entity;

import javax.annotation.Nullable;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.menu.CollectorContainerMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.InventoryBlockEntity;
import slimeknights.mantle.util.WeakConsumerWrapper;

public class CollectorBlockEntity
extends InventoryBlockEntity {
    private static final Component TITLE = Component.m_237115_((String)"gui.inspirations.collector");
    @Nullable
    private LazyOptional<IItemHandler> facingHandler;
    @Nullable
    private AABB itemBounds;
    private final NonNullConsumer<IItemHandler> extractItem = this::extractItem;
    private final NonNullConsumer<LazyOptional<IItemHandler>> facingInvalidator = new WeakConsumerWrapper((Object)this, (te, handler) -> {
        if (te.facingHandler == handler) {
            te.clearCachedInventories();
        }
    });

    public CollectorBlockEntity(BlockPos pos, BlockState state) {
        super(InspirationsUtility.tileCollector, pos, state, TITLE, false, 9);
    }

    public void collect() {
        if (this.f_58857_ == null) {
            return;
        }
        LazyOptional<IItemHandler> handler = this.getHandler();
        if (handler.isPresent()) {
            handler.ifPresent(this.extractItem);
        } else {
            boolean collected = false;
            for (ItemEntity entity : this.f_58857_.m_6443_(ItemEntity.class, this.getItemBounds(), EntitySelector.f_20402_)) {
                ItemStack insert = entity.m_32055_();
                ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)insert, (boolean)false);
                if (remainder.m_41613_() >= insert.m_41613_()) continue;
                collected = true;
                if (remainder.m_41619_()) {
                    entity.m_146870_();
                    continue;
                }
                entity.m_32045_(remainder);
            }
            this.f_58857_.m_46796_(collected ? 1000 : 1001, this.f_58858_, 0);
        }
    }

    private LazyOptional<IItemHandler> getHandler() {
        LazyOptional handler;
        if (this.facingHandler != null) {
            return this.facingHandler;
        }
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing));
        if (te != null && (handler = te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_())).isPresent()) {
            handler.addListener(this.facingInvalidator);
            this.facingHandler = handler;
            return this.facingHandler;
        }
        this.facingHandler = LazyOptional.empty();
        return this.facingHandler;
    }

    private AABB getItemBounds() {
        if (this.itemBounds == null) {
            BlockPos offset = this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_));
            this.itemBounds = new AABB((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_(), (double)(offset.m_123341_() + 1), (double)(offset.m_123342_() + 1), (double)(offset.m_123343_() + 1));
        }
        return this.itemBounds;
    }

    private void extractItem(IItemHandler neighbor) {
        for (int i = 0; i < neighbor.getSlots(); ++i) {
            ItemStack simulated = neighbor.extractItem(i, 1, true);
            if (simulated.m_41619_() || !ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)simulated, (boolean)false).m_41619_()) continue;
            neighbor.extractItem(i, 1, false);
            break;
        }
    }

    public void clearCachedInventories() {
        this.facingHandler = null;
    }

    public void m_155250_(BlockState pBlockState) {
        super.m_155250_(pBlockState);
        this.clearCachedInventories();
    }

    public boolean m_7013_(int slot, ItemStack itemstack) {
        return slot < this.m_6643_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int winId, Inventory playerInv, Player player) {
        return new CollectorContainerMenu(winId, playerInv, this);
    }
}

