/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.MilkablePacket;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.RegistryHelper;

@Mod.EventBusSubscriber(modid="inspirations", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TweaksEvents {
    public static final String TAG_MILKCOOLDOWN = "milk_cooldown";

    @SubscribeEvent
    static void unsaddlePig(PlayerInteractEvent.EntityInteract event) {
        Pig pig;
        Entity target;
        if (!Config.enablePigDesaddle.getAsBoolean()) {
            return;
        }
        Player player = event.getEntity();
        ItemStack stack = player.m_21120_(event.getHand());
        if (player.m_6047_() && stack.m_41619_() && (target = event.getTarget()) instanceof Pig && (pig = (Pig)target).m_6254_()) {
            pig.f_29459_.m_20849_(false);
            pig.m_9236_().m_6263_(player, pig.m_20185_(), pig.m_20186_(), pig.m_20189_(), SoundEvents.f_12236_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42450_), (int)player.m_150109_().f_35977_);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void extraBonemeal(BonemealEvent event) {
        if (!(Config.bonemealMushrooms.getAsBoolean() || Config.bonemealDeadBush.getAsBoolean() || Config.bonemealGrassSpread.getAsBoolean() || Config.bonemealMyceliumSpread.getAsBoolean())) {
            return;
        }
        Level world = event.getLevel();
        if (world.f_46443_) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (Config.bonemealMushrooms.getAsBoolean() && block == Blocks.f_50195_ || Config.bonemealDeadBush.getAsBoolean() && RegistryHelper.contains((TagKey)BlockTags.f_13029_, (Block)block)) {
            TweaksEvents.bonemealPlants(block, world, pos);
            event.setResult(Event.Result.ALLOW);
        } else if ((Config.bonemealGrassSpread.getAsBoolean() || Config.bonemealMyceliumSpread.getAsBoolean()) && block == Blocks.f_50493_ && TweaksEvents.bonemealDirt(world, pos)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    private static void bonemealPlants(Block base, Level world, BlockPos pos) {
        BlockPos up = pos.m_7494_();
        BushBlock bush = (BushBlock)Blocks.f_50036_;
        BlockState state = bush.m_49966_();
        boolean isMycelium = base == Blocks.f_50195_;
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos next = up;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!world.m_46859_(next) || world.f_46441_.m_188503_(128) != 0) continue block0;
                    if (isMycelium) {
                        bush = (BushBlock)(world.f_46441_.m_188503_(2) == 0 ? Blocks.f_50073_ : Blocks.f_50072_);
                        state = bush.m_49966_();
                    }
                    if (!bush.m_7898_(state, (LevelReader)world, next)) continue block0;
                    world.m_46597_(next, state);
                    continue block0;
                }
                if (world.m_8055_((next = next.m_7918_(world.f_46441_.m_188503_(3) - 1, (world.f_46441_.m_188503_(3) - 1) * world.f_46441_.m_188503_(3) / 2, world.f_46441_.m_188503_(3) - 1)).m_7495_()).m_60734_() != base || world.m_8055_(next).m_60796_((BlockGetter)world, next)) continue block0;
                ++j;
            }
        }
    }

    private static boolean bonemealDirt(Level world, BlockPos pos) {
        if (world.m_46803_(pos.m_7494_()) < 9) {
            return false;
        }
        int grass = 0;
        int mycelium = 0;
        for (Direction side : Direction.Plane.HORIZONTAL) {
            BlockPos offset = pos.m_121945_(side);
            BlockState state = world.m_8055_(offset);
            Block block = state.m_60734_();
            if (state.m_60795_()) {
                state = world.m_8055_(offset.m_7495_());
                block = state.m_60734_();
            } else if (block != Blocks.f_50440_ && block != Blocks.f_50195_) {
                state = world.m_8055_(offset.m_7494_());
                block = state.m_60734_();
            }
            if (Config.bonemealGrassSpread.getAsBoolean() && block == Blocks.f_50440_) {
                ++grass;
                continue;
            }
            if (!Config.bonemealMyceliumSpread.getAsBoolean() || block != Blocks.f_50195_) continue;
            ++mycelium;
        }
        if (grass == 0 && mycelium == 0) {
            return false;
        }
        if (world.f_46441_.m_188503_(5) > Math.max(grass, mycelium) - 1) {
            return true;
        }
        if (grass == mycelium && world.f_46441_.m_188499_()) {
            ++mycelium;
        }
        world.m_46597_(pos, grass >= mycelium ? Blocks.f_50440_.m_49966_() : Blocks.f_50195_.m_49966_());
        return true;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void onFall(LivingFallEvent event) {
        double z;
        if (!Config.lilypadBreakFall.getAsBoolean()) {
            return;
        }
        if (event.getDistance() < 4.0f) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        if (world.f_46443_) {
            return;
        }
        Vec3 vec = entity.m_20182_();
        if (vec.f_82480_ % 1.0 > 0.09375) {
            return;
        }
        BlockPos blockPos = entity.m_20183_();
        BlockPos[] posList = new BlockPos[4];
        int i = 0;
        posList[i++] = blockPos;
        double x = vec.f_82479_ % 1.0;
        if (x < 0.0) {
            x += 1.0;
        }
        if ((z = vec.f_82481_ % 1.0) < 0.0) {
            z += 1.0;
        }
        if (x > 0.7) {
            posList[i++] = blockPos.m_122029_();
        } else if (x < 0.3) {
            posList[i++] = blockPos.m_122024_();
        }
        if (z > 0.7) {
            posList[i++] = blockPos.m_122019_();
            if (i == 3) {
                posList[i++] = posList[1].m_122019_();
            }
        } else if (z < 0.3) {
            posList[i++] = blockPos.m_122012_();
            if (i == 3) {
                posList[i++] = posList[1].m_122012_();
            }
        }
        boolean safe = false;
        for (BlockPos pos : posList) {
            if (pos == null || world.m_8055_(pos).m_60734_() != Blocks.f_50196_) continue;
            world.m_46961_(pos, true);
            safe = true;
        }
        if (safe) {
            event.setDistance(0.0f);
        }
    }

    @SubscribeEvent
    static void milkCow(PlayerInteractEvent.EntityInteract event) {
        Goat goat;
        Cow cow;
        if (!((Boolean)Config.milkCooldown.get()).booleanValue() && !Config.enableMilkBottles.getAsBoolean()) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof Cow && !(cow = (Cow)target).m_6162_() || target instanceof Goat && !(goat = (Goat)target).m_6162_())) {
            return;
        }
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        ItemStack stack = player.m_21120_(hand);
        if (((Boolean)Config.milkCooldown.get()).booleanValue() && stack.m_204117_(InspirationsTags.Items.MILK_CONTAINERS)) {
            CompoundTag tags = target.getPersistentData();
            if (tags.m_128448_(TAG_MILKCOOLDOWN) > 0) {
                event.setCancellationResult(InteractionResult.PASS);
                event.setCanceled(true);
                return;
            }
            tags.m_128376_(TAG_MILKCOOLDOWN, ((Integer)Config.milkCooldownTime.get()).shortValue());
            if (!event.getLevel().f_46443_) {
                InspirationsNetwork.sendToClients(event.getLevel(), target.m_20183_(), (ISimplePacket)new MilkablePacket(target, false));
            }
        }
        if (stack.m_150930_(Items.f_42590_) && Config.enableMilkBottles.getAsBoolean()) {
            player.m_21008_(hand, ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)new ItemStack((ItemLike)InspirationsCaudrons.milkBottle)));
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void updateMilkCooldown(LivingEvent.LivingTickEvent event) {
        CompoundTag tags;
        short cooldown;
        LivingEntity entity = event.getEntity();
        Level world = entity.m_20193_();
        if (world.f_46443_ || world.m_46467_() % 20L != 0L) {
            return;
        }
        if (((Boolean)Config.milkCooldown.get()).booleanValue() && (entity instanceof Cow || entity instanceof Goat) && !entity.m_6162_() && (cooldown = (tags = entity.getPersistentData()).m_128448_(TAG_MILKCOOLDOWN)) > 0) {
            tags.m_128376_(TAG_MILKCOOLDOWN, (short)(cooldown - 1));
            if (cooldown == 1) {
                InspirationsNetwork.sendToClients(world, entity.m_20183_(), (ISimplePacket)new MilkablePacket((Entity)entity, true));
            }
        }
    }
}

