/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks;

import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.function.Consumer;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.InspirationsCommons;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.tweaks.block.BlockCropBlock;
import knightminer.inspirations.tweaks.block.CactusCropBlock;
import knightminer.inspirations.tweaks.block.DryHopperBlock;
import knightminer.inspirations.tweaks.block.FittedCarpetBlock;
import knightminer.inspirations.tweaks.block.FlatCarpetBlock;
import knightminer.inspirations.tweaks.block.SugarCaneCropBlock;
import knightminer.inspirations.tweaks.block.WetHopperBlock;
import knightminer.inspirations.tweaks.datagen.TweaksRecipeProvider;
import knightminer.inspirations.tweaks.recipe.NormalBrewingRecipe;
import knightminer.inspirations.tweaks.util.SmoothGrowthListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsTweaks
extends ModuleBase {
    public static BlockCropBlock cactus;
    public static BlockCropBlock sugarCane;
    public static HopperBlock wetHopper;
    public static HopperBlock dryHopper;
    public static EnumObject<DyeColor, FittedCarpetBlock> fitCarpets;
    public static EnumObject<DyeColor, Block> flatCarpets;
    public static Item sugarCaneSeeds;
    public static Item cactusSeeds;
    public static Item heartbeet;
    private static final DispenseItemBehavior DEFAULT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey == Registries.f_256747_) {
            BlockRegistryAdapter registry = new BlockRegistryAdapter(ForgeRegistries.BLOCKS);
            boolean replaceVanilla = Config.enableFittedCarpets.getAsBoolean();
            EnumObject.Builder flatBuilder = new EnumObject.Builder(DyeColor.class);
            EnumObject.Builder fittedBuilder = new EnumObject.Builder(DyeColor.class);
            for (DyeColor color : DyeColor.values()) {
                Block original = (Block)InspirationsCommons.VANILLA_CARPETS.get((Enum)color);
                BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)original);
                if (replaceVanilla) {
                    flatBuilder.put((Enum)color, (Object)((Block)registry.register((Object)new FlatCarpetBlock(color, props), (Object)original)));
                } else {
                    flatBuilder.put((Enum)color, (Object)original);
                }
                fittedBuilder.put((Enum)color, (Object)((FittedCarpetBlock)((Object)registry.register((Object)new FittedCarpetBlock(color, props.m_60910_()), color.m_7912_() + "_fitted_carpet"))));
            }
            flatCarpets = flatBuilder.build();
            fitCarpets = fittedBuilder.build();
            if (Config.waterlogHopper.getAsBoolean()) {
                dryHopper = (HopperBlock)registry.registerOverride(DryHopperBlock::new, Blocks.f_50332_);
                wetHopper = (HopperBlock)registry.register((Object)new WetHopperBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50332_)), "wet_hopper");
            }
            cactus = (BlockCropBlock)((Object)registry.register((Object)new CactusCropBlock(() -> Blocks.f_50128_, PlantType.DESERT, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50128_)), "cactus"));
            sugarCane = (BlockCropBlock)((Object)registry.register((Object)new SugarCaneCropBlock(() -> Blocks.f_50130_, PlantType.BEACH, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50130_)), "sugar_cane"));
        } else if (registryKey == Registries.f_256913_) {
            ItemRegistryAdapter registry = new ItemRegistryAdapter(ForgeRegistries.ITEMS);
            Item.Properties props = new Item.Properties();
            if (Config.enableFittedCarpets.getAsBoolean()) {
                for (DyeColor color : DyeColor.values()) {
                    Block carpet = (Block)InspirationsCommons.VANILLA_CARPETS.get((Enum)color);
                    BlockItem item = registry.registerBlockItem(carpet, props);
                    Item.f_41373_.put(carpet, item);
                    Item.f_41373_.put(Objects.requireNonNull((Block)flatCarpets.get((Enum)color)), item);
                }
            }
            if (Config.waterlogHopper.getAsBoolean()) {
                registry.register((Object)new BlockItem((Block)dryHopper, props), (Object)Items.f_42155_);
            }
            cactusSeeds = (Item)registry.register((Object)new ItemNameBlockItem((Block)cactus, props), "cactus_seeds");
            sugarCaneSeeds = (Item)registry.register((Object)new ItemNameBlockItem((Block)sugarCane, props), "sugar_cane_seeds");
            heartbeet = registry.register(new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(2).m_38758_(2.4f).effect(() -> new MobEffectInstance(MobEffects.f_19605_, 100), 1.0f).m_38767_()), "heartbeet");
        } else if (registryKey == Registries.f_256922_ && Config.waterlogHopper.getAsBoolean()) {
            BlockEntityType blockEntityType = BlockEntityType.f_58933_;
            synchronized (blockEntityType) {
                BlockEntityType.f_58933_.f_58915_ = new ImmutableSet.Builder().addAll((Iterable)BlockEntityType.f_58933_.f_58915_).add((Object)dryHopper).add((Object)wetHopper).build();
            }
        }
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        Ingredient heartbeet = Ingredient.m_43929_((ItemLike[])new ItemLike[]{InspirationsTweaks.heartbeet});
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.f_43599_, heartbeet, Potions.f_43600_, Config.brewHeartbeet));
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new NormalBrewingRecipe(Potions.f_43602_, heartbeet, Potions.f_43587_, Config.brewHeartbeet));
        event.enqueueWork(this::registerCompostables);
        this.registerDispenserBehavior();
        MinecraftForge.EVENT_BUS.addListener((Consumer)new SmoothGrowthListener(Blocks.f_50128_, (Block)cactus));
        MinecraftForge.EVENT_BUS.addListener((Consumer)new SmoothGrowthListener(Blocks.f_50130_, (Block)sugarCane));
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeServer(), (DataProvider)new TweaksRecipeProvider(gen.getPackOutput()));
    }

    @SubscribeEvent
    public static void loadLoot(LootTableLoadEvent event) {
        InspirationsTweaks.addToVanillaLoot(event, "entities/cave_spider");
        InspirationsTweaks.addToVanillaLoot(event, "entities/skeleton");
    }

    private void registerCompostables() {
        ComposterBlock.m_51920_((float)0.3f, (ItemLike)cactusSeeds);
        ComposterBlock.m_51920_((float)0.3f, (ItemLike)sugarCaneSeeds);
        ComposterBlock.m_51920_((float)0.8f, (ItemLike)heartbeet);
    }

    private void registerDispenserBehavior() {
        DispenseItemBehavior behavior = (source, stack) -> {
            if (!Config.dispensersPlaceAnvils.getAsBoolean()) {
                DEFAULT.m_6115_(source, stack);
            }
            Direction facing = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
            ServerLevel world = source.m_7727_();
            BlockPos pos = source.m_7961_().m_121945_(facing);
            DirectionalPlaceContext context = new DirectionalPlaceContext((Level)world, pos, facing, stack, facing.m_122424_());
            if (((BlockItem)stack.m_41720_()).m_40576_((BlockPlaceContext)context) == InteractionResult.SUCCESS) {
                return stack;
            }
            return DEFAULT.m_6115_(source, stack);
        };
        DispenserBlock.m_52672_((ItemLike)Blocks.f_50322_, (DispenseItemBehavior)behavior);
        DispenserBlock.m_52672_((ItemLike)Blocks.f_50323_, (DispenseItemBehavior)behavior);
        DispenserBlock.m_52672_((ItemLike)Blocks.f_50324_, (DispenseItemBehavior)behavior);
    }

    static {
        fitCarpets = EnumObject.empty();
        flatCarpets = EnumObject.empty();
        DEFAULT = new DefaultDispenseItemBehavior();
    }
}

