/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.capability;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.network.DimensionCompassPositionPacket;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.tools.capability.IDimensionCompass;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class DimensionCompass
implements ICapabilitySerializable<CompoundTag>,
IDimensionCompass {
    public static final ResourceLocation KEY = Inspirations.getResource("dimension_compass");
    public static final Capability<IDimensionCompass> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDimensionCompass>(){});
    private final LazyOptional<IDimensionCompass> capabilityInstance = LazyOptional.of(() -> this);
    private BlockPos enteredPosition;

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(EventPriority.NORMAL, false, RegisterCapabilitiesEvent.class, event -> event.register(IDimensionCompass.class));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, DimensionCompass::attachCapability);
        MinecraftForge.EVENT_BUS.addListener(DimensionCompass::dimensionChange);
        MinecraftForge.EVENT_BUS.addListener(DimensionCompass::playerLoggedIn);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, DimensionCompass::dimensionTravel);
    }

    @Override
    @Nullable
    public BlockPos getEnteredPosition() {
        return this.enteredPosition;
    }

    @Override
    public void setEnteredPosition(@Nullable BlockPos pos) {
        this.enteredPosition = pos;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CAPABILITY) {
            return this.capabilityInstance.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        BlockPos pos = this.getEnteredPosition();
        if (pos == null) {
            return new CompoundTag();
        }
        return NbtUtils.m_129224_((BlockPos)pos);
    }

    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128425_("X", 99) && nbt.m_128425_("Y", 99) && nbt.m_128425_("Z", 99)) {
            this.setEnteredPosition(NbtUtils.m_129239_((CompoundTag)nbt));
        } else {
            this.setEnteredPosition(null);
        }
    }

    private static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player) {
            event.addCapability(KEY, (ICapabilityProvider)new DimensionCompass());
        }
    }

    private static void sync(Player player, @Nullable BlockPos pos) {
        if (player instanceof ServerPlayer) {
            InspirationsNetwork.INSTANCE.sendTo(new DimensionCompassPositionPacket(pos), (ServerPlayer)player);
        }
    }

    private static void dimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        BlockPos pos = player.m_20183_();
        DimensionCompass.sync(player, pos);
        player.getCapability(CAPABILITY).ifPresent(compass -> compass.setEnteredPosition(pos));
    }

    private static void dimensionTravel(EntityTravelToDimensionEvent event) {
        Entity entity;
        if (event.getDimension() == Level.f_46428_ && (entity = event.getEntity()).m_20193_().m_46472_() == Level.f_46430_ && entity instanceof ServerPlayer) {
            entity.getCapability(CAPABILITY).ifPresent(compass -> compass.setEnteredPosition(null));
            InspirationsNetwork.INSTANCE.sendTo(new DimensionCompassPositionPacket((BlockPos)null), (ServerPlayer)entity);
        }
    }

    private static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        player.getCapability(CAPABILITY).ifPresent(compass -> {
            BlockPos pos = compass.getEnteredPosition();
            if (pos != null) {
                DimensionCompass.sync(player, pos);
            }
        });
    }
}

