/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import knightminer.inspirations.cauldrons.block.entity.PotionCauldronBlockEntity;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.network.packet.IThreadsafePacket;
import slimeknights.mantle.util.BlockEntityHelper;

public class CauldronPotionUpdatePacket
implements IThreadsafePacket {
    private final BlockPos pos;
    private final Potion potion;

    public CauldronPotionUpdatePacket(BlockPos pos, Potion potion) {
        this.pos = pos;
        this.potion = potion;
    }

    public CauldronPotionUpdatePacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.potion = (Potion)buffer.readRegistryIdUnsafe(ForgeRegistries.POTIONS);
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeRegistryIdUnsafe(ForgeRegistries.POTIONS, (Object)this.potion);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(CauldronPotionUpdatePacket packet) {
            BlockEntityHelper.get(PotionCauldronBlockEntity.class, (BlockGetter)Minecraft.m_91087_().f_91073_, (BlockPos)packet.pos, (boolean)true).ifPresent(te -> {
                if (te.setPotion(packet.potion)) {
                    MiscUtil.notifyClientUpdate((BlockEntity)te);
                }
            });
        }
    }
}

