/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.block.entity;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import slimeknights.mantle.block.entity.MantleBlockEntity;

public class SuspiciousStewCauldronBlockEntity
extends MantleBlockEntity {
    private static final String EFFECT_NAME = "forge:effect_id";
    private ListTag effects = new ListTag();

    public SuspiciousStewCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(InspirationsCaudrons.suspiciousStewCauldronEntity, pos, state);
    }

    public ListTag getEffects() {
        return this.effects;
    }

    public void setEffects(ListTag effects) {
        this.effects = effects.m_6426_();
        this.setChangedFast();
    }

    public void addEffect(MobEffect effect, int duration) {
        CompoundTag effectTag = new CompoundTag();
        effectTag.m_128344_("EffectId", (byte)MobEffect.m_19459_((MobEffect)effect));
        ForgeHooks.saveMobEffect((CompoundTag)effectTag, (String)EFFECT_NAME, (MobEffect)effect);
        effectTag.m_128405_("EffectDuration", duration);
        this.effects.add((Object)effectTag);
        this.setChangedFast();
    }

    @Nullable
    private static MobEffect getEffect(CompoundTag tag) {
        MobEffect effect = MobEffect.m_19453_((int)tag.m_128445_("EffectId"));
        return ForgeHooks.loadMobEffect((CompoundTag)tag, (String)EFFECT_NAME, (MobEffect)effect);
    }

    private static void scaleList(Map<MobEffect, CompoundTag> existingEffects, ListTag list, int size) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag effectTag = list.m_128728_(i);
            MobEffect effect = SuspiciousStewCauldronBlockEntity.getEffect(effectTag);
            if (effect == null) continue;
            int duration = effectTag.m_128451_("EffectDuration") * size;
            CompoundTag existing = existingEffects.get(effect);
            if (existing != null) {
                existing.m_128405_("EffectDuration", duration + existing.m_128451_("EffectDuration"));
                continue;
            }
            effectTag = effectTag.m_6426_();
            effectTag.m_128405_("EffectDuration", duration);
            existingEffects.put(effect, effectTag);
        }
    }

    public void mergeEffects(int existingSize, ListTag mergeEffects, int mergeSize) {
        HashMap<MobEffect, CompoundTag> existingEffects = new HashMap<MobEffect, CompoundTag>();
        SuspiciousStewCauldronBlockEntity.scaleList(existingEffects, this.effects, existingSize);
        SuspiciousStewCauldronBlockEntity.scaleList(existingEffects, mergeEffects, mergeSize);
        this.effects = new ListTag();
        int totalSize = mergeSize + existingSize;
        for (CompoundTag effect : existingEffects.values()) {
            effect.m_128405_("EffectDuration", effect.m_128451_("EffectDuration") / totalSize);
            this.effects.add((Object)effect);
        }
        this.setChangedFast();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.effects = nbt.m_128437_("Effects", 10).m_6426_();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Effects", (Tag)this.effects.m_6426_());
    }
}

