/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.block.entity;

import javax.annotation.Nullable;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.network.CauldronColorUpdatePacket;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.mantle.network.packet.ISimplePacket;

public class DyeCauldronBlockEntity
extends MantleBlockEntity {
    private static final String TAG_COLOR = "color";
    private int color;
    private boolean dyeDirty = true;
    @Nullable
    private DyeColor dye;

    public DyeCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(InspirationsCaudrons.dyeCauldronEntity, pos, state);
    }

    public int getColor() {
        return this.color;
    }

    @Nullable
    public DyeColor getDye() {
        if (this.dyeDirty) {
            this.dye = MiscUtil.getDyeForColor(this.color);
            this.dyeDirty = false;
        }
        return this.dye;
    }

    public boolean setColor(int color) {
        if (color != this.color) {
            this.color = color;
            this.dyeDirty = true;
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                InspirationsNetwork.sendToClients(this.f_58857_, this.f_58858_, (ISimplePacket)new CauldronColorUpdatePacket(this.f_58858_, color));
            }
            this.setChangedFast();
            return true;
        }
        return false;
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    protected void saveSynced(CompoundTag nbt) {
        super.saveSynced(nbt);
        nbt.m_128405_(TAG_COLOR, this.color);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.color = nbt.m_128451_(TAG_COLOR);
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            MiscUtil.notifyClientUpdate((BlockEntity)this);
        }
        this.dyeDirty = true;
    }
}

