/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.ShelfBlock;
import knightminer.inspirations.building.block.entity.ShelfInventory;
import knightminer.inspirations.building.block.menu.ShelfContainerMenu;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.block.entity.IRetexturedBlockEntity;
import slimeknights.mantle.block.entity.NameableBlockEntity;
import slimeknights.mantle.network.packet.ISimplePacket;
import slimeknights.mantle.util.RetexturedHelper;

public class ShelfBlockEntity
extends NameableBlockEntity
implements IRetexturedBlockEntity {
    private static final String TAG_TEXTURE = "texture";
    public static final ModelProperty<Integer> BOOKS = new ModelProperty();
    private static final Component TITLE = Component.m_237115_((String)"gui.inspirations.shelf.name");
    private float enchantBonus = Float.NaN;
    private final ShelfInventory inventory = new ShelfInventory(this);
    private final LazyOptional<IItemHandler> itemCapability = LazyOptional.of(() -> this.inventory);
    private Block texture = Blocks.f_50016_;
    private int books = 0;
    private static final String TAG_ITEMS = "Items";

    public ShelfBlockEntity(BlockPos pos, BlockState state) {
        super(InspirationsBuilding.shelfTileEntity, pos, state, TITLE);
    }

    private int getIndexFromHit(ItemStack held, Vec3 click) {
        Direction dir;
        double clicked;
        int pixel;
        int shelfIndex;
        int slotIndex = (click.f_82480_ <= 0.4375 ? 8 : 0) + (shelfIndex = (pixel = Mth.m_14045_((int)((int)((clicked = (double)(dir = ((Direction)this.m_58900_().m_61143_((Property)ShelfBlock.FACING)).m_122428_()).m_122429_() * (click.f_82479_ - 0.5) + (double)dir.m_122431_() * (click.f_82481_ - 0.5) + 0.5) * 16.0)), (int)0, (int)15)) / 2);
        if (!this.inventory.getStackInSlot(slotIndex).m_41619_()) {
            return slotIndex;
        }
        boolean previousEmpty = false;
        if (shelfIndex != 0) {
            ItemStack previous = this.inventory.getStackInSlot(slotIndex - 1);
            if (!previous.m_41619_() && !InspirationsRegistry.isBook(previous)) {
                return slotIndex - 1;
            }
            previousEmpty = previous.m_41619_();
        }
        if (held.m_41619_()) {
            return -1;
        }
        if (InspirationsRegistry.isBook(held)) {
            return slotIndex;
        }
        if (shelfIndex == 7 || !this.inventory.getStackInSlot(slotIndex + 1).m_41619_()) {
            return previousEmpty ? slotIndex - 1 : -1;
        }
        if (previousEmpty && pixel % 2 == 0) {
            if (shelfIndex == 1) {
                return slotIndex - 1;
            }
            ItemStack beforePrevious = this.inventory.getStackInSlot(slotIndex - 2);
            if (beforePrevious.m_41619_() || InspirationsRegistry.isBook(beforePrevious)) {
                return slotIndex - 1;
            }
        }
        return slotIndex;
    }

    public boolean interact(Player player, InteractionHand hand, Vec3 click) {
        ItemStack stack = player.m_21120_(hand);
        int index = this.getIndexFromHit(stack, click);
        if (index == -1) {
            return false;
        }
        ItemStack current = this.inventory.getStackInSlot(index);
        if (!current.m_41619_()) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)current, (int)player.m_150109_().f_35977_);
                this.inventory.setStackInSlot(index, ItemStack.f_41583_);
            }
            return true;
        }
        if (this.inventory.canInsertItem(index, stack)) {
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.inventory.setStackInSlot(index, stack.m_41620_(1));
            }
            return true;
        }
        return false;
    }

    public void onSlotChanged(int slot, ItemStack oldStack, ItemStack newStack) {
        this.setChangedFast();
        Level world = this.m_58904_();
        if (world != null) {
            if (!world.f_46443_) {
                InspirationsNetwork.sendToClients(world, this.f_58858_, (ISimplePacket)new InventorySlotSyncPacket(newStack, slot, this.f_58858_));
            } else {
                int oldBooks = this.books;
                int books = InspirationsRegistry.isBook(newStack) ? oldBooks | 1 << slot : oldBooks & ~(1 << slot);
                if (books != oldBooks) {
                    this.books = books;
                    RetexturedHelper.onTextureUpdated((BlockEntity)this);
                }
            }
            if (oldStack.m_41720_() == InspirationsBuilding.redstoneBook ^ newStack.m_41720_() == InspirationsBuilding.redstoneBook) {
                world.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            }
        }
        this.enchantBonus = Float.NaN;
    }

    public ShelfInventory getInventory() {
        return this.inventory;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCapability.invalidate();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int winId, Inventory playerInv, Player player) {
        return new ShelfContainerMenu(winId, playerInv, this);
    }

    public int getComparatorPower() {
        for (int i = 16; i >= 0; --i) {
            if (this.inventory.getStackInSlot(i).m_41720_() != InspirationsBuilding.redstoneBook) continue;
            return i;
        }
        return 0;
    }

    public float getEnchantPower() {
        if (!Float.isNaN(this.enchantBonus)) {
            return this.enchantBonus;
        }
        float books = 0.0f;
        for (int i = 0; i < 16; ++i) {
            float power;
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.m_41619_() || !((power = InspirationsRegistry.getBookEnchantingPower(stack)) > 0.0f)) continue;
            books += power;
        }
        this.enchantBonus = books / 16.0f;
        return this.enchantBonus;
    }

    public Block getTexture() {
        return this.texture;
    }

    public String getTextureName() {
        return RetexturedHelper.getTextureName((Block)this.texture);
    }

    public void updateTexture(String name) {
        Block oldTexture = this.texture;
        this.texture = RetexturedHelper.getBlock((String)name);
        if (oldTexture != this.texture) {
            this.setChangedFast();
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }

    private void refreshBooks() {
        int books = 0;
        for (int i = 0; i < 16; ++i) {
            if (!InspirationsRegistry.isBook(this.inventory.getStackInSlot(i))) continue;
            books |= 1 << i;
        }
        this.books = books;
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(BOOKS, (Object)this.books).with(RetexturedHelper.BLOCK_PROPERTY, (Object)this.getTexture()).build();
    }

    protected boolean shouldSyncOnUpdate() {
        return true;
    }

    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        tags.m_128365_(TAG_ITEMS, (Tag)this.inventory.serializeNBT());
        if (this.texture != Blocks.f_50016_) {
            tags.m_128359_(TAG_TEXTURE, this.getTextureName());
        }
    }

    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        boolean needsUpdate = false;
        if (tags.m_128425_(TAG_ITEMS, 9)) {
            this.inventory.deserializeNBT(tags.m_128437_(TAG_ITEMS, 10));
            this.refreshBooks();
            needsUpdate = true;
        }
        if (tags.m_128425_(TAG_TEXTURE, 8)) {
            this.texture = RetexturedHelper.getBlock((String)tags.m_128461_(TAG_TEXTURE));
            needsUpdate = true;
        }
        if (needsUpdate) {
            RetexturedHelper.onTextureUpdated((BlockEntity)this);
        }
    }
}

