/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TorchLeverBlock
extends TorchBlock {
    private static final DirectionProperty SWING = DirectionProperty.m_61546_((String)"swing", dir -> dir != Direction.DOWN);

    public TorchLeverBlock(BlockBehaviour.Properties props, ParticleOptions particles) {
        super(props, particles);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SWING, (Comparable)Direction.UP));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SWING});
    }

    private boolean isPowered(BlockState state) {
        return state.m_61143_((Property)SWING) != Direction.UP;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        Direction swing = (Direction)state.m_61143_((Property)SWING);
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.7;
        double z = (double)pos.m_123343_() + 0.5;
        if (this.isPowered(state)) {
            int offsetX = swing.m_122429_();
            int offsetZ = swing.m_122431_();
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x + 0.23 * (double)offsetX, y - 0.05, z + 0.23 * (double)offsetZ, 0.0, 0.0, 0.0);
            world.m_7106_(this.f_57488_, x + 0.23 * (double)offsetX, y - 0.05, z + 0.23 * (double)offsetZ, 0.0, 0.0, 0.0);
        } else {
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            world.m_7106_(this.f_57488_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        float pitch;
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (this.isPowered(state)) {
            state = (BlockState)state.m_61124_((Property)SWING, (Comparable)Direction.UP);
            pitch = 0.5f;
        } else {
            state = (BlockState)state.m_61124_((Property)SWING, (Comparable)player.m_6350_());
            pitch = 0.6f;
        }
        world.m_7731_(pos, state, 3);
        world.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, pitch);
        world.m_46672_(pos, (Block)this);
        world.m_46672_(pos.m_7495_(), (Block)this);
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_() && !isMoving && this.isPowered(state)) {
            world.m_46672_(pos, (Block)this);
            world.m_46672_(pos.m_7495_(), (Block)this);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Deprecated
    public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return this.isPowered(state) ? 15 : 0;
    }

    @Deprecated
    public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        if (!this.isPowered(state)) {
            return 0;
        }
        return side == Direction.DOWN ? 15 : 0;
    }

    @Deprecated
    public boolean m_7899_(BlockState state) {
        return true;
    }
}

