/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools;

import knightminer.inspirations.common.AbstractClientEvents;
import knightminer.inspirations.library.MiscUtil;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tools.client.BarometerPropertyGetter;
import knightminer.inspirations.tools.client.DimensionCompassPropertyGetter;
import knightminer.inspirations.tools.client.NorthCompassPropertyGetter;
import knightminer.inspirations.tools.client.PhotometerPropertyGetter;
import knightminer.inspirations.tools.client.RedstoneArrowRenderer;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ToolsClientEvents
extends AbstractClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        ToolsClientEvents.registerModelProperty((ItemLike)InspirationsTools.northCompass, "angle", new NorthCompassPropertyGetter());
        ToolsClientEvents.registerModelProperty((ItemLike)InspirationsTools.barometer, "height", new BarometerPropertyGetter());
        ToolsClientEvents.registerModelProperty((ItemLike)InspirationsTools.photometer, "light", new PhotometerPropertyGetter());
        ToolsClientEvents.registerModelProperty((ItemLike)InspirationsTools.dimensionCompass, "angle", new DimensionCompassPropertyGetter());
        if (InspirationsTools.shield != null) {
            ItemProperties.register((Item)InspirationsTools.shield, (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        }
    }

    @SubscribeEvent
    static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(InspirationsTools.entRSArrow, RedstoneArrowRenderer::new);
    }

    @SubscribeEvent
    static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        ToolsClientEvents.registerItemColors(itemColors, (stack, tintIndex) -> {
            if (tintIndex == 1 && MiscUtil.hasColor(stack)) {
                return MiscUtil.getColor(stack);
            }
            return tintIndex == 0 ? -1 : 2936241;
        }, new ItemLike[]{InspirationsTools.dimensionCompass});
    }
}

