/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class MilkablePacket
implements IThreadsafePacket {
    private final int entityID;
    private final boolean milkable;

    public MilkablePacket(Entity entity, boolean milkable) {
        this.entityID = entity.m_19879_();
        this.milkable = milkable;
    }

    public MilkablePacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.milkable = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.milkable);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(MilkablePacket packet) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityID);
            if (entity == null) {
                return;
            }
            entity.getPersistentData().m_128376_("milk_cooldown", (short)(packet.milkable ? 0 : 100));
        }
    }
}

