/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.data;

import java.util.EnumSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.cauldrons.data.VanillaEnum;
import knightminer.inspirations.common.InspirationsCommons;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.common.datagen.IInspirationsRecipeBuilder;
import knightminer.inspirations.library.InspirationsTags;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.mantle.recipe.data.ConsumerWrapperBuilder;

public class RecipesRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IInspirationsRecipeBuilder {
    public RecipesRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "Inspirations Recipes - Recipes";
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        String folder = "cauldron/";
        String mixFolder = folder + "bottle/mix/";
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.CYAN, DyeColor.BLUE, DyeColor.GREEN);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.GRAY, DyeColor.BLACK, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.LIGHT_GRAY, DyeColor.BLACK, DyeColor.WHITE, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.LIME, DyeColor.GREEN, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.RED, DyeColor.PINK);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.MAGENTA, DyeColor.BLUE, DyeColor.RED, DyeColor.RED, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.MAGENTA, DyeColor.PURPLE, DyeColor.PINK);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.ORANGE, DyeColor.RED, DyeColor.YELLOW);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.PINK, DyeColor.RED, DyeColor.WHITE);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.PURPLE, DyeColor.BLUE, DyeColor.RED);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.GREEN, ConfigEnabledCondition.EXTRA_BOTTLE_RECIPES, DyeColor.BLUE, DyeColor.YELLOW);
        this.addDyedBottleMix(consumer, mixFolder, DyeColor.BROWN, ConfigEnabledCondition.EXTRA_BOTTLE_RECIPES, DyeColor.RED, DyeColor.YELLOW, DyeColor.BLUE);
        Consumer bottleConsumer = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.CAULDRON_DYEING});
        String bottleFolder = folder + "bottle/";
        InspirationsCaudrons.simpleDyedWaterBottle.forEach((dye, bottle) -> {
            String name = dye.m_7912_();
            InventoryChangeTrigger.TriggerInstance hasBottle = RecipesRecipeProvider.m_125977_((ItemLike)bottle);
            this.addComboRecipe(bottleConsumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)VanillaEnum.WOOL.get((Enum)dye), "wool", (TagKey<Item>)ItemTags.f_13167_, (ItemLike)bottle, this.location(bottleFolder + "wool/" + name));
            this.addSurroundRecipe(bottleConsumer, RecipeCategory.DECORATIONS, (ItemLike)VanillaEnum.CARPET.get((Enum)dye), "carpet", InspirationsTags.Items.CARPETS, (ItemLike)bottle, this.location(bottleFolder + "carpet/" + name));
            this.addComboRecipe(bottleConsumer, RecipeCategory.DECORATIONS, (ItemLike)VanillaEnum.BED.get((Enum)dye), "dyed_bed", (TagKey<Item>)ItemTags.f_13146_, (ItemLike)bottle, this.location(bottleFolder + "beds/" + name));
            this.addSurroundRecipe(bottleConsumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)VanillaEnum.STAINED_GLASS.get((Enum)dye), "stained_glass", (TagKey<Item>)Tags.Items.GLASS_COLORLESS, (ItemLike)bottle, this.location(bottleFolder + "stained_glass/" + name));
            this.addSurroundRecipe(bottleConsumer, RecipeCategory.DECORATIONS, (ItemLike)VanillaEnum.STAINED_GLASS_PANE.get((Enum)dye), "stained_glass_pane", (TagKey<Item>)Tags.Items.GLASS_PANES_COLORLESS, (ItemLike)bottle, this.location(bottleFolder + "stained_glass_pane/" + name));
            this.addSurroundRecipe(bottleConsumer, RecipeCategory.BUILDING_BLOCKS, (ItemLike)VanillaEnum.TERRACOTTA.get((Enum)dye), "stained_terracotta", InspirationsTags.Items.TERRACOTTA, (ItemLike)bottle, this.location(bottleFolder + "terracotta/" + name));
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)InspirationsCaudrons.getConcretePowder(dye), (int)8).m_126145_("concrete_powder").m_126209_((ItemLike)bottle).m_206419_(ItemTags.f_13137_).m_206419_(ItemTags.f_13137_).m_206419_(ItemTags.f_13137_).m_206419_(ItemTags.f_13137_).m_206419_(Tags.Items.GRAVEL).m_206419_(Tags.Items.GRAVEL).m_206419_(Tags.Items.GRAVEL).m_206419_(Tags.Items.GRAVEL).m_126132_("has_item", (CriterionTriggerInstance)hasBottle).m_126140_(bottleConsumer, this.location(bottleFolder + "concrete_powder/" + name));
        });
        ItemLike blackBottle = (ItemLike)InspirationsCaudrons.simpleDyedWaterBottle.get((Enum)DyeColor.BLACK);
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.f_42614_).m_126145_(this.id((ItemLike)Items.f_42614_).m_135815_()).m_126209_(blackBottle).m_206419_(Tags.Items.FEATHERS).m_126209_((ItemLike)Items.f_42517_).m_126132_("has_item", (CriterionTriggerInstance)RecipesRecipeProvider.m_125977_((ItemLike)blackBottle)).m_126140_(bottleConsumer, this.location(bottleFolder + "writable_book"));
        Consumer potionConsumer = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.CAULDRON_POTIONS});
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.FOOD, (ItemLike)InspirationsCaudrons.potatoSoupItem).m_126209_((ItemLike)Items.f_42399_).m_126209_((ItemLike)Items.f_42674_).m_126209_((ItemLike)Items.f_42674_).m_206419_(Tags.Items.MUSHROOMS).m_126132_("has_item", (CriterionTriggerInstance)RecipesRecipeProvider.m_125977_((ItemLike)Items.f_42674_)).m_126140_(this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.CAULDRON_SOUPS}), this.location(folder + "potato_soup"));
    }

    private void addDyedBottleMix(Consumer<FinishedRecipe> consumer, String folder, DyeColor output, DyeColor ... inputs) {
        this.addDyedBottleMix(consumer, folder, output, (ICondition)null, inputs);
    }

    private void addDyedBottleMix(Consumer<FinishedRecipe> baseConsumer, String folder, DyeColor output, @Nullable ICondition extraCondition, DyeColor ... inputs) {
        ConsumerWrapperBuilder consumerBuilder = ConsumerWrapperBuilder.wrap((RecipeSerializer)InspirationsCommons.shapelessNoContainer).addCondition((ICondition)ConfigEnabledCondition.CAULDRON_DYEING);
        if (extraCondition != null) {
            consumerBuilder.addCondition(extraCondition);
        }
        Consumer consumer = consumerBuilder.build(baseConsumer);
        StringBuilder name = new StringBuilder(folder + output.m_7912_() + "_from");
        Item outputItem = (Item)InspirationsCaudrons.simpleDyedWaterBottle.get((Enum)output);
        ShapelessRecipeBuilder builder = ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)outputItem, (int)inputs.length).m_126145_(this.id((ItemLike)outputItem).toString());
        EnumSet<DyeColor> seen = EnumSet.noneOf(DyeColor.class);
        for (DyeColor input : inputs) {
            ItemLike bottle = (ItemLike)InspirationsCaudrons.simpleDyedWaterBottle.get((Enum)input);
            builder.m_126209_(bottle);
            if (seen.contains(input)) continue;
            builder.m_126132_("has_" + input.m_7912_(), (CriterionTriggerInstance)RecipesRecipeProvider.m_125977_((ItemLike)bottle));
            name.append("_").append(input.m_7912_());
            seen.add(input);
        }
        builder.m_176500_(consumer, this.prefix(name.toString()));
    }

    private void addSurroundRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike output, String group, TagKey<Item> surround, ItemLike center, ResourceLocation location) {
        ShapedRecipeBuilder.m_246608_((RecipeCategory)category, (ItemLike)output, (int)8).m_126145_(group).m_206416_(Character.valueOf('#'), surround).m_126127_(Character.valueOf('x'), center).m_126130_("###").m_126130_("#x#").m_126130_("###").m_126132_("has_item", (CriterionTriggerInstance)RecipesRecipeProvider.m_125977_((ItemLike)center)).m_126140_(consumer, location);
    }

    private void addComboRecipe(Consumer<FinishedRecipe> consumer, RecipeCategory category, ItemLike output, String group, TagKey<Item> input, ItemLike modifier, ResourceLocation location) {
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)category, (ItemLike)output).m_126145_(group).m_206419_(input).m_126209_(modifier).m_126132_("has_item", (CriterionTriggerInstance)RecipesRecipeProvider.m_125977_((ItemLike)modifier)).m_126140_(consumer, location);
    }
}

