/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block.entity;

import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShelfInventory
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<ListTag> {
    public static final int MAX_ITEMS = 16;
    private final ShelfBlockEntity parent;
    private final NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)16, (Object)ItemStack.f_41583_);
    private static final String SLOT_TAG = "Slot";

    public ShelfInventory(ShelfBlockEntity parent) {
        this.parent = parent;
    }

    private void onSlotChanged(int slot, ItemStack oldStack) {
        this.parent.onSlotChanged(slot, oldStack, (ItemStack)this.stacks.get(slot));
    }

    public int getSlots() {
        return 16;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }

    private boolean isSlotValid(int slot) {
        return slot >= 0 && slot < 16;
    }

    public boolean canHoldItem(int slot, ItemStack stack) {
        ItemStack previous;
        if (!this.isSlotValid(slot) || stack.m_41619_()) {
            return false;
        }
        if (slot != 0 && slot != 8 && !(previous = (ItemStack)this.stacks.get(slot - 1)).m_41619_() && !InspirationsRegistry.isBook(previous)) {
            return false;
        }
        if (InspirationsRegistry.isBook(stack)) {
            return true;
        }
        if (slot == 7 || slot == 15) {
            return false;
        }
        return ((ItemStack)this.stacks.get(slot + 1)).m_41619_();
    }

    public boolean canInsertItem(int slot, ItemStack stack) {
        return this.canHoldItem(slot, stack) && ((ItemStack)this.stacks.get(slot)).m_41619_();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.isSlotValid(slot) ? (ItemStack)this.stacks.get(slot) : ItemStack.f_41583_;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        if (stack.m_41619_() || this.canHoldItem(slot, stack)) {
            ItemStack oldStack = (ItemStack)this.stacks.get(slot);
            this.stacks.set(slot, (Object)stack);
            this.onSlotChanged(slot, oldStack);
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.canInsertItem(slot, stack)) {
            return stack;
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - 1));
        if (!simulate) {
            this.setStackInSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        return result;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || !this.isSlotValid(slot)) {
            return ItemStack.f_41583_;
        }
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (current.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)1);
        if (!simulate) {
            this.setStackInSlot(slot, ItemStack.f_41583_);
        }
        return result;
    }

    public ListTag serializeNBT() {
        ListTag list = new ListTag();
        for (int i = 0; i < 16; ++i) {
            ItemStack stack = (ItemStack)this.stacks.get(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_(SLOT_TAG, (byte)i);
            stack.m_41739_(itemTag);
            list.add((Object)itemTag);
        }
        return list;
    }

    public void deserializeNBT(ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemNBT = list.m_128728_(i);
            int slot = itemNBT.m_128445_(SLOT_TAG) & 0xFF;
            if (!this.isSlotValid(slot)) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemNBT));
        }
    }
}

