package knightminer.inspirations.cauldrons.block;

import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome.Precipitation;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;

import java.util.Map;
import java.util.function.Predicate;

import static knightminer.inspirations.cauldrons.block.BoilingFourLayerCauldronBlock.isBoiling;

/** Cauldron block that has four layers and emits boiling particles when over fire */
public class BoilingThreeLayerCauldronBlock extends LayeredCauldronBlock {
	public BoilingThreeLayerCauldronBlock(Properties props, Predicate<Precipitation> fillPredicate, Map<Item,CauldronInteraction> interactions) {
		super(props, fillPredicate, interactions);
	}

	@Override
	public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
		if (!world.isClientSide && isEntityInsideContent(state, pos, entity)) {
			if (isBoiling(world, pos)) {
				BoilingFourLayerCauldronBlock.boil(entity);
			}
			if (entity.isOnFire()) {
				entity.clearFire();
				if (entity.mayInteract(world, pos)) {
					this.handleEntityOnFireInside(state, world, pos);
				}
			}
		}
	}

	@Override
	public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
		if (isBoiling(level, pos)) {
			MiscUtil.addParticles(InspirationsCaudrons.boilingParticle, level, pos, 2, getContentHeight(state), rand);
		}
	}
}
