/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import javax.annotation.Nullable;
import knightminer.inspirations.utility.block.entity.CollectorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.mantle.block.InventoryBlock;

public class CollectorBlock
extends InventoryBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final BooleanProperty TRIGGERED = BlockStateProperties.f_61360_;

    public CollectorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TRIGGERED});
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_7820_();
        Player player = context.m_43723_();
        if (player != null && player.m_6047_()) {
            facing = facing.m_122424_();
        }
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = world.m_7702_(pos)) instanceof Container) {
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)((Container)te));
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CollectorBlockEntity(pos, state);
    }

    protected boolean openGui(Player player, Level world, BlockPos pos) {
        if (!(player instanceof ServerPlayer)) {
            throw new AssertionError((Object)"Needs to be server!");
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof CollectorBlockEntity) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)te), (BlockPos)pos);
            return true;
        }
        return false;
    }

    @Deprecated
    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null) {
            return te.getCapability(ForgeCapabilities.ITEM_HANDLER, null).map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
        }
        return 0;
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighbor, boolean isMoving) {
        BlockEntity te;
        if (pos.m_121945_((Direction)state.m_61143_((Property)FACING)).equals((Object)neighbor) && (te = world.m_7702_(pos)) instanceof CollectorBlockEntity) {
            ((CollectorBlockEntity)te).clearCachedInventories();
        }
        boolean powered = world.m_276867_(pos) || world.m_276867_(pos.m_7494_());
        boolean triggered = (Boolean)state.m_61143_((Property)TRIGGERED);
        if (powered && !triggered) {
            world.m_186460_(pos, (Block)this, 4);
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!powered && triggered) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    @Deprecated
    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof CollectorBlockEntity) {
            ((CollectorBlockEntity)te).collect();
        }
    }
}

