/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.util;

import java.util.function.Consumer;
import knightminer.inspirations.common.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;

public class SmoothGrowthListener
implements Consumer<BlockEvent.CropGrowEvent.Pre> {
    private final Block crop;
    private final Block seed;

    public SmoothGrowthListener(Block crop, Block seed) {
        this.crop = crop;
        this.seed = seed;
    }

    @Override
    public void accept(BlockEvent.CropGrowEvent.Pre event) {
        BlockPos dest;
        BlockPos source;
        BlockPos pos;
        if (!Config.smoothBlockCropGrowth.getAsBoolean()) {
            return;
        }
        if (event.getState().m_60734_() != this.crop) {
            return;
        }
        LevelAccessor world = event.getLevel();
        if (world.m_8055_(pos = event.getPos()).m_60734_() == this.crop) {
            source = pos;
            dest = pos.m_7494_();
        } else {
            source = pos.m_7495_();
            dest = pos;
        }
        BlockState state = this.seed.m_49966_();
        world.m_7731_(dest, state, 3);
        if (world.m_8055_(source).m_60734_() == this.crop) {
            world.m_7731_(source, this.crop.m_49966_(), 4);
        }
        event.setResult(Event.Result.DENY);
        if (world instanceof Level) {
            Level casted = (Level)world;
            state.m_60690_(casted, dest, this.seed, source, false);
            ForgeHooks.onCropsGrowPost((Level)casted, (BlockPos)source, (BlockState)state);
        }
    }
}

