/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.WordUtils;
import slimeknights.mantle.data.loadable.Loadables;

public final class ClientUtil {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static final Map<Item, Integer> COLOR_CACHE = new HashMap<Item, Integer>();
    private static final Set<Item> UNSAFE_COLORS = new HashSet<Item>();
    private static final Map<String, String> NORMALIZED_NAMES = new HashMap<String, String>();
    public static final ResourceManagerReloadListener RELOAD_LISTENER = manager -> COLOR_CACHE.clear();

    private ClientUtil() {
    }

    public static int getItemColor(Item item) {
        return COLOR_CACHE.computeIfAbsent(item, ClientUtil::getItemColorRaw);
    }

    private static Integer getItemColorRaw(Item key) {
        BakedModel model = mc.m_91291_().m_174264_(new ItemStack((ItemLike)key), null, null, 0);
        if (model == mc.m_91304_().m_119409_()) {
            return -1;
        }
        TextureAtlasSprite sprite = model.getParticleIcon(ModelData.EMPTY);
        if (sprite == null || sprite.m_245424_().m_246162_() == MissingTextureAtlasSprite.m_118071_()) {
            return -1;
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float count = 0.0f;
        float[] hsb = new float[3];
        try {
            SpriteContents contents = sprite.m_245424_();
            for (int x = 0; x < contents.m_246492_(); ++x) {
                for (int y = 0; y < contents.m_245330_(); ++y) {
                    int argb = sprite.getPixelRGBA(0, x, y);
                    int cr = argb & 0xFF;
                    int cg = argb >> 8 & 0xFF;
                    int cb = argb >> 16 & 0xFF;
                    int ca = argb >> 24 & 0xFF;
                    if (ca <= 127 || NumberUtils.max((int)cr, (int)cg, (int)cb) <= 31) continue;
                    Color.RGBtoHSB(ca, cr, cg, hsb);
                    float weight = hsb[1];
                    r += (float)cr * weight;
                    g += (float)cg * weight;
                    b += (float)cb * weight;
                    count += weight;
                }
            }
        }
        catch (Exception e) {
            InspirationsRegistry.log.error("Caught exception reading sprite for {}", (Object)Loadables.ITEM.getKey((Object)key), (Object)e);
            return -1;
        }
        if (count > 0.0f) {
            r /= count;
            g /= count;
            b /= count;
        }
        return 0xFF000000 | (int)r << 16 | (int)g << 8 | (int)b;
    }

    public static TextureAtlasSprite getSprite(@Nullable ResourceLocation location) {
        TextureAtlas atlas = mc.m_91304_().m_119428_(InventoryMenu.f_39692_);
        if (location == null) {
            return atlas.m_118316_(MissingTextureAtlasSprite.m_118071_());
        }
        return atlas.m_118316_(location);
    }

    public static void renderFilledSprite(TextureAtlasSprite sprite, int x, int y, int size, int filled) {
        float uMin = sprite.m_118409_();
        float uMax = sprite.m_118410_();
        float vMin = sprite.m_118411_();
        float vMax = sprite.m_118412_();
        uMax -= (float)(16 - size) / 16.0f * (uMax - uMin);
        vMax -= (float)(16 - filled) / 16.0f * (vMax - vMin);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        bufferBuilder.m_5483_((double)x, (double)(y + size), 100.0).m_7421_(uMin, vMax).m_5752_();
        bufferBuilder.m_5483_((double)(x + size), (double)(y + size), 100.0).m_7421_(uMax, vMax).m_5752_();
        bufferBuilder.m_5483_((double)(x + size), (double)(y + size - filled), 100.0).m_7421_(uMax, vMin).m_5752_();
        bufferBuilder.m_5483_((double)x, (double)(y + size - filled), 100.0).m_7421_(uMin, vMin).m_5752_();
        tessellator.m_85914_();
    }

    public static int getStackBlockColorsSafe(ItemStack stack, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int index) {
        if (stack.m_41619_()) {
            return -1;
        }
        Item item = stack.m_41720_();
        if (!UNSAFE_COLORS.contains(item)) {
            try {
                return ClientUtil.getStackBlockColors(stack, world, pos, index);
            }
            catch (Exception e) {
                Inspirations.log.error("Caught exception getting block colors for {}", (Object)Loadables.ITEM.getKey((Object)item), (Object)e);
                UNSAFE_COLORS.add(item);
            }
        }
        return mc.getItemColors().m_92676_(stack, index);
    }

    public static int getStackBlockColors(ItemStack stack, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int index) {
        Item item;
        if (stack.m_41619_() || !((item = stack.m_41720_()) instanceof BlockItem)) {
            return -1;
        }
        BlockItem item2 = (BlockItem)item;
        BlockState state = item2.m_40614_().m_49966_();
        return mc.m_91298_().m_92577_(state, world, pos, index);
    }

    public static String normalizeName(String name) {
        return NORMALIZED_NAMES.computeIfAbsent(name, s -> WordUtils.capitalizeFully((String)name.replace('_', ' ')));
    }
}

