/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.mantle.network.packet.IThreadsafePacket;

public class InventorySlotSyncPacket
implements IThreadsafePacket {
    private final ItemStack itemStack;
    private final int slot;
    private final BlockPos pos;

    public InventorySlotSyncPacket(ItemStack itemStack, int slot, BlockPos pos) {
        this.itemStack = itemStack;
        this.pos = pos;
        this.slot = slot;
    }

    public InventorySlotSyncPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.slot = buf.readShort();
        this.itemStack = buf.m_130267_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeShort(this.slot);
        buf.writeItemStack(this.itemStack, false);
    }

    public void handleThreadsafe(NetworkEvent.Context context) {
        HandleClient.handle(this);
    }

    private static class HandleClient {
        private HandleClient() {
        }

        private static void handle(InventorySlotSyncPacket packet) {
            assert (Minecraft.m_91087_().f_91073_ != null);
            BlockEntity tileEntity = Minecraft.m_91087_().f_91073_.m_7702_(packet.pos);
            if (tileEntity != null) {
                tileEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    if (handler instanceof IItemHandlerModifiable) {
                        IItemHandlerModifiable itemHandler = (IItemHandlerModifiable)handler;
                        itemHandler.setStackInSlot(packet.slot, packet.itemStack);
                    }
                });
            }
        }
    }
}

