/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons;

import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.cauldrons.block.entity.DyeCauldronBlockEntity;
import knightminer.inspirations.cauldrons.block.entity.PotionCauldronBlockEntity;
import knightminer.inspirations.cauldrons.client.BoilingParticle;
import knightminer.inspirations.cauldrons.item.MixedDyedBottleItem;
import knightminer.inspirations.common.AbstractClientEvents;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="inspirations", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class CauldronsClientEvents
extends AbstractClientEvents {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)InspirationsCaudrons.honey, (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)InspirationsCaudrons.honey.m_5615_(), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((state, level, pos, index) -> {
            BlockEntity be;
            if (index == 0 && level != null && pos != null && (be = level.m_7702_(pos)) != null && be.m_58903_() == InspirationsCaudrons.dyeCauldronEntity) {
                return ((DyeCauldronBlockEntity)be).getColor();
            }
            return -1;
        }, new Block[]{InspirationsCaudrons.dyeCauldron});
        colors.m_92589_((state, level, pos, index) -> {
            BlockEntity be;
            if (index == 0 && level != null && pos != null && (be = level.m_7702_(pos)) != null && be.m_58903_() == InspirationsCaudrons.potionCauldronEntity) {
                Potion potion = ((PotionCauldronBlockEntity)be).getPotion();
                return potion == Potions.f_43598_ ? -1 : PotionUtils.m_43559_((Potion)potion);
            }
            return -1;
        }, new Block[]{InspirationsCaudrons.potionCauldron});
    }

    @SubscribeEvent
    static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        Minecraft.m_91087_().f_91061_.m_107378_((ParticleType)InspirationsCaudrons.boilingParticle, BoilingParticle.Factory::new);
    }

    @SubscribeEvent
    static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        InspirationsCaudrons.simpleDyedWaterBottle.forEach((color, bottle) -> itemColors.m_92689_((stack, index) -> index == 0 ? MiscUtil.getColor(color) : -1, new ItemLike[]{bottle}));
        CauldronsClientEvents.registerItemColors(itemColors, (stack, index) -> index == 0 ? MixedDyedBottleItem.dyeFromBottle(stack) : -1, new ItemLike[]{InspirationsCaudrons.mixedDyedWaterBottle});
        event.register(CauldronsClientEvents.fluidColor(InspirationsCaudrons.mushroomStewType), new ItemLike[]{InspirationsCaudrons.mushroomStewBucket});
        event.register(CauldronsClientEvents.fluidColor(InspirationsCaudrons.potatoSoupType), new ItemLike[]{InspirationsCaudrons.potatoSoupBucket});
        event.register(CauldronsClientEvents.fluidColor(InspirationsCaudrons.rabbitStewType), new ItemLike[]{InspirationsCaudrons.rabbitStewBucket});
        event.register(CauldronsClientEvents.fluidColor(InspirationsCaudrons.beetrootSoupType), new ItemLike[]{InspirationsCaudrons.beetrootSoupBucket});
        event.register(CauldronsClientEvents.fluidColor(InspirationsCaudrons.honeyType), new ItemLike[]{InspirationsCaudrons.honeyBucket});
    }

    private static ItemColor fluidColor(FluidType type) {
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((FluidType)type);
        return (stack, index) -> index == 1 ? extensions.getTintColor() : -1;
    }
}

