/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.datagen;

import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.type.MulchType;
import knightminer.inspirations.building.block.type.PathType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.common.data.ConfigEnabledCondition;
import knightminer.inspirations.common.data.FinishedNBTRecipe;
import knightminer.inspirations.common.datagen.IInspirationsRecipeBuilder;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import slimeknights.mantle.recipe.crafting.ShapedRetexturedRecipeBuilder;

public class BuildingRecipeProvider
extends RecipeProvider
implements IConditionBuilder,
IInspirationsRecipeBuilder {
    public BuildingRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    public String m_6055_() {
        return "Inspirations Recipes - Building";
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
        Consumer glassDoorCondition = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.GLASS_DOOR});
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)InspirationsBuilding.glassDoor).m_126132_("has_glass", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_42027_)).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42027_).m_126130_("GG").m_126130_("GG").m_126130_("GG").m_126140_(glassDoorCondition, this.prefix(this.id((ItemLike)InspirationsBuilding.glassDoor), "building/"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)InspirationsBuilding.glassTrapdoor, (int)2).m_126132_("has_glass", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_42027_)).m_126127_(Character.valueOf('G'), (ItemLike)Items.f_42027_).m_126130_("GGG").m_126130_("GGG").m_126140_(glassDoorCondition, this.prefix(this.id((ItemLike)InspirationsBuilding.glassTrapdoor), "building/"));
        Consumer ropeCondition = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.ROPE});
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)InspirationsBuilding.rope, (int)3).m_126132_("has_string", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)Tags.Items.STRING)).m_126127_(Character.valueOf('S'), (ItemLike)Items.f_42401_).m_126130_("SS").m_126130_("SS").m_126130_("SS").m_126140_(ropeCondition, this.prefix(this.id((ItemLike)InspirationsBuilding.rope), "building/"));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)InspirationsBuilding.vine, (int)3).m_126132_("has_vines", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_42029_)).m_126127_(Character.valueOf('V'), (ItemLike)Items.f_42029_).m_126130_("V").m_126130_("V").m_126130_("V").m_126140_(ropeCondition, this.prefix(this.id((ItemLike)InspirationsBuilding.vine), "building/"));
        Consumer pathCondition = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.PATH});
        this.addPath(pathCondition, PathType.BRICK, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41995_}), (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_41995_));
        this.addPath(pathCondition, PathType.ROCK, Ingredient.m_204132_((TagKey)Tags.Items.COBBLESTONE), (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)Tags.Items.COBBLESTONE));
        this.addPath(pathCondition, PathType.ROUND, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41905_}), (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_41905_));
        this.addPath(pathCondition, PathType.TILE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42018_}), (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_42018_));
        Consumer mulchCondition = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.MULCH});
        ItemLike plainMulch = (ItemLike)InspirationsBuilding.mulch.get((Enum)MulchType.PLAIN);
        SingleItemRecipeBuilder.m_245264_((Ingredient)Ingredient.m_204132_((TagKey)ItemTags.f_13168_), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)plainMulch).m_126132_("hasPlanks", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)ItemTags.f_13168_)).m_126140_(mulchCondition, this.location("building/mulch/" + MulchType.PLAIN.m_7912_()));
        InspirationsBuilding.mulch.forEach((type, mulch) -> {
            DyeColor dye = type.getDye();
            if (dye != null) {
                ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)mulch).m_126132_("has_mulch", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)plainMulch)).m_126209_(plainMulch).m_206419_(dye.getTag()).m_126140_(mulchCondition, this.location("building/mulch/" + type.m_7912_()));
            }
        });
        Consumer bookConditions = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.COLORED_BOOKS});
        String bookGroup = this.prefix("colored_book");
        for (DyeColor color : DyeColor.values()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag display = new CompoundTag();
            tag.m_128365_("display", (Tag)display);
            display.m_128405_("color", MiscUtil.getColor(color));
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)InspirationsBuilding.coloredBook).m_126132_("has_bookshelf", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_(InspirationsTags.Items.BOOKSHELVES)).m_126145_(bookGroup).m_126209_((ItemLike)Items.f_42517_).m_206419_(color.getTag()).m_126140_(FinishedNBTRecipe.withNBT(bookConditions, tag), this.location("building/books/" + color.m_7912_()));
        }
        Consumer flowerConditions = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.FLOWERS});
        InspirationsBuilding.flower.forEach((type, flower) -> {
            Item dye = type.getDye();
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)dye).m_126132_("has_flower", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)flower)).m_126145_(Objects.requireNonNull(dye).toString()).m_126209_((ItemLike)flower).m_126140_(flowerConditions, this.prefix(this.id((ItemLike)dye), "building/flower/"));
        });
        Consumer bookshelfConditions = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.BOOKSHELF});
        String shelfGroup = this.prefix("bookshelf");
        InspirationsBuilding.shelf.forEach((type, shelf) -> {
            String[] variants;
            for (String variant : variants = BuildingRecipeProvider.getShelfVariants(type)) {
                ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)shelf, (int)2).m_126145_(shelfGroup).m_126132_("has_slabs", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)ItemTags.f_13175_)).m_126132_("has_book", (CriterionTriggerInstance)BuildingRecipeProvider.m_125977_((ItemLike)Items.f_42517_)).m_206416_(Character.valueOf('S'), ItemTags.f_13175_).m_126130_("SSS").m_126130_(variant).m_126130_("SSS");
                switch (type) {
                    case ANCIENT: {
                        builder.m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42516_);
                        break;
                    }
                    case TOMES: {
                        builder.m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_);
                        break;
                    }
                    case RAINBOW: {
                        builder.m_206416_(Character.valueOf('R'), Tags.Items.DYES_RED).m_206416_(Character.valueOf('G'), Tags.Items.DYES_GREEN).m_206416_(Character.valueOf('B'), Tags.Items.DYES_BLUE);
                    }
                }
                String suffix = variants.length > 1 ? "_" + variant.toLowerCase(Locale.US) : "";
                ShapedRetexturedRecipeBuilder.fromShaped((ShapedRecipeBuilder)builder).setSource(ItemTags.f_13175_).setMatchAll().build(bookshelfConditions, this.location("building/bookshelves/" + type.m_7912_() + suffix));
            }
        });
        Consumer bushConditions = this.withCondition(consumer, new ICondition[]{ConfigEnabledCondition.ENLIGHTENED_BUSH});
        String bushGroup = this.prefix("enlightened_bush");
        InspirationsBuilding.enlightenedBush.forEach((type, bush) -> {
            ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bush).m_126145_(bushGroup).m_126132_("has_leaves", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)ItemTags.f_13143_)).m_126132_("has_glowstone", (CriterionTriggerInstance)BuildingRecipeProvider.m_206406_((TagKey)Tags.Items.DUSTS_GLOWSTONE)).m_206416_(Character.valueOf('L'), ItemTags.f_13143_).m_206416_(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE);
            DyeColor dye = type.getDye();
            if (dye != null) {
                builder = builder.m_206416_(Character.valueOf('D'), dye.getTag()).m_126130_(" D ");
            }
            builder.m_126130_("GLG");
            ShapedRetexturedRecipeBuilder.fromShaped((ShapedRecipeBuilder)builder).setSource(ItemTags.f_13143_).build(bushConditions, this.location("building/enlightened_bush/" + type.m_7912_()));
        });
    }

    private void addPath(Consumer<FinishedRecipe> consumer, PathType type, Ingredient ingredient, CriterionTriggerInstance criteria) {
        ItemLike path = (ItemLike)InspirationsBuilding.path.get((Enum)type);
        if (type != PathType.ROUND) {
            ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)path, (int)6).m_126132_("has_item", criteria).m_126124_(Character.valueOf('C'), ingredient).m_126130_("CC").m_126140_(consumer, this.location("building/path/" + type.m_7912_() + "_crafting"));
        }
        SingleItemRecipeBuilder.m_246944_((Ingredient)ingredient, (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)path, (int)6).m_126132_("has_stone", criteria).m_126140_(consumer, this.location("building/path/" + type.m_7912_() + "_cutting"));
    }

    private static String[] getShelfVariants(ShelfType type) {
        String[] stringArray;
        switch (type) {
            default: {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = " S ";
                break;
            }
            case ANCIENT: {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "PPP";
                break;
            }
            case TOMES: {
                String[] stringArray4 = new String[1];
                stringArray = stringArray4;
                stringArray4[0] = " B ";
                break;
            }
            case RAINBOW: {
                String[] stringArray5 = new String[3];
                stringArray5[0] = "RGB";
                stringArray5[1] = "RBG";
                stringArray = stringArray5;
                stringArray5[2] = "GRB";
            }
        }
        return stringArray;
    }
}

