/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.client;

import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.building.block.entity.ShelfInventory;
import knightminer.inspirations.building.block.menu.ShelfContainerMenu;
import knightminer.inspirations.common.client.BackgroundContainerScreen;
import knightminer.inspirations.library.InspirationsRegistry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.screen.ElementScreen;

public class ShelfContainerScreen
extends BackgroundContainerScreen<ShelfContainerMenu> {
    private static final ResourceLocation BACKGROUND = Inspirations.getResource("textures/gui/shelf.png");
    private static final ElementScreen SLOT_COVER = new ElementScreen(BACKGROUND, 176, 0, 18, 18, 256, 256);
    private static final ElementScreen BOOK_SLOT_ICON = new ElementScreen(BACKGROUND, 176, 18, 16, 16, 256, 256);

    public ShelfContainerScreen(ShelfContainerMenu container, Inventory inventory, Component name) {
        super(container, inventory, name, 156, BACKGROUND);
    }

    private void checkBookIcon(GuiGraphics graphics, ShelfInventory inventory, int index) {
        if (inventory.getStackInSlot(index).m_41619_() && (index % 8 == 7 || !inventory.getStackInSlot(index + 1).m_41619_())) {
            Slot slot = ((ShelfContainerMenu)this.m_6262_()).m_38853_(index);
            BOOK_SLOT_ICON.draw(graphics, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_);
        }
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        ShelfBlockEntity shelf = (ShelfBlockEntity)((ShelfContainerMenu)this.m_6262_()).getTile();
        if (shelf != null) {
            ShelfInventory inventory = shelf.getInventory();
            for (int i = 0; i < 16; ++i) {
                this.checkBookIcon(graphics, inventory, i);
            }
        }
    }

    private void checkCoverSlot(GuiGraphics graphics, ShelfInventory inventory, int index) {
        ItemStack previous;
        if (inventory.getStackInSlot(index).m_41619_() && !(previous = inventory.getStackInSlot(index - 1)).m_41619_() && !InspirationsRegistry.isBook(previous)) {
            Slot slot = ((ShelfContainerMenu)this.m_6262_()).m_38853_(index);
            SLOT_COVER.draw(graphics, slot.f_40220_ - 1, slot.f_40221_ - 1);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
        super.m_280003_(graphics, x, y);
        ShelfBlockEntity shelf = (ShelfBlockEntity)((ShelfContainerMenu)this.m_6262_()).getTile();
        if (shelf != null) {
            int i;
            ShelfInventory inventory = shelf.getInventory();
            for (i = 1; i < 8; ++i) {
                this.checkCoverSlot(graphics, inventory, i);
            }
            for (i = 9; i < 16; ++i) {
                this.checkCoverSlot(graphics, inventory, i);
            }
        }
    }
}

