/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RopeBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Rungs> RUNGS = EnumProperty.m_61587_((String)"rungs", Rungs.class);
    public static final BooleanProperty BOTTOM = BooleanProperty.m_61465_((String)"bottom");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final int RUNG_ITEM_COUNT = 4;
    private final Item rungsItem;
    private static final VoxelShape ATTACH_TOP = Block.m_49796_((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape ATTACH_BOTTOM = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0);
    private static final VoxelShape[] SHAPE = new VoxelShape[3];
    private static final VoxelShape[] SHAPE_BOTTOM = new VoxelShape[3];

    public RopeBlock(Item rungsItem, BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(false))).m_61124_(RUNGS, (Comparable)((Object)Rungs.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.rungsItem = rungsItem;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BOTTOM, RUNGS, WATERLOGGED});
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public Item getRungsItem() {
        return this.rungsItem;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos down = context.m_8083_().m_7495_();
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom(context.m_43725_().m_8055_(down), (BlockGetter)context.m_43725_(), down)))).m_61124_(RUNGS, (Comparable)((Object)Rungs.NONE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    private boolean isBottom(BlockState state, BlockGetter world, BlockPos pos) {
        if (state.m_60734_() == this) {
            return false;
        }
        return state.m_204336_(BlockTags.f_13035_) || Shapes.m_83157_((VoxelShape)state.m_60812_(world, pos).m_83263_(Direction.UP), (VoxelShape)ATTACH_TOP, (BooleanOp)BooleanOp.f_82683_);
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return super.m_7898_(state, world, pos) && this.isValidRope(world, pos);
    }

    private boolean isValidRope(LevelReader world, BlockPos pos) {
        BlockPos up = pos.m_7494_();
        BlockState state = world.m_8055_(up);
        if (state.m_60734_() == this) {
            return true;
        }
        return !state.m_204336_(BlockTags.f_13035_) && !Shapes.m_83157_((VoxelShape)state.m_60812_((BlockGetter)world, pos).m_83263_(Direction.DOWN), (VoxelShape)ATTACH_BOTTOM, (BooleanOp)BooleanOp.f_82683_);
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        if (!this.isValidRope((LevelReader)world, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (facing == Direction.DOWN) {
            BlockPos down = pos.m_7495_();
            return (BlockState)state.m_61124_((Property)BOTTOM, (Comparable)Boolean.valueOf(this.isBottom(world.m_8055_(down), (BlockGetter)world, down)));
        }
        return state;
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (hit.m_82434_().m_122434_().m_122478_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (Block.m_49814_((Item)stack.m_41720_()) != this) {
            return InteractionResult.PASS;
        }
        BlockPos next = pos.m_7495_();
        while (world.m_8055_(next).m_60734_() == this) {
            next = next.m_7495_();
        }
        if (this.m_7898_(state, (LevelReader)world, next)) {
            ((BlockItem)stack.m_41720_()).m_40576_(new BlockPlaceContext(player, hand, stack, new BlockHitResult(Vec3.m_82539_((Vec3i)next), Direction.UP, next, false)));
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos next = pos.m_7495_();
        int count = 0;
        int rungs = 0;
        BlockState below = world.m_8055_(next);
        while (below.m_60734_() == this) {
            ++count;
            if (below.m_61143_(RUNGS) != Rungs.NONE) {
                ++rungs;
            }
            next = next.m_7495_();
            below = world.m_8055_(next);
        }
        for (int i = 0; i < count; ++i) {
            next = next.m_7494_();
            world.m_46961_(next, false);
        }
        ItemStack drops = new ItemStack((ItemLike)this, count);
        RopeBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)drops);
        if (rungs > 0) {
            RopeBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.rungsItem, rungs * 4));
        }
        super.m_5707_(world, pos, state, player);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.m_61143_((Property)BOTTOM) != false ? SHAPE_BOTTOM : SHAPE)[((Rungs)((Object)state.m_61143_(RUNGS))).ordinal()];
    }

    @Deprecated
    public VoxelShape m_5939_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return state.m_61143_(RUNGS) != Rungs.NONE ? state.m_60808_(worldIn, pos) : Shapes.m_83040_();
    }

    static {
        VoxelShape rope_core = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape rope_core_bottom = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)7.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.5, (double)4.0, (double)6.5, (double)9.5, (double)7.0, (double)9.5));
        VoxelShape rope_rungs_x = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.0, (double)5.0, (double)7.0, (double)15.0, (double)7.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)9.0, (double)7.0, (double)15.0, (double)11.0, (double)9.0), Block.m_49796_((double)1.0, (double)13.0, (double)7.0, (double)15.0, (double)15.0, (double)9.0)});
        VoxelShape rope_rungs_z = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)5.0, (double)1.0, (double)9.0, (double)7.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)7.0, (double)9.0, (double)1.0, (double)9.0, (double)11.0, (double)15.0), Block.m_49796_((double)7.0, (double)13.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0)});
        RopeBlock.SHAPE[Rungs.NONE.ordinal()] = rope_core;
        RopeBlock.SHAPE_BOTTOM[Rungs.NONE.ordinal()] = rope_core_bottom;
        RopeBlock.SHAPE[Rungs.X.ordinal()] = Shapes.m_83124_((VoxelShape)rope_core, (VoxelShape[])new VoxelShape[]{rope_rungs_x, Block.m_49796_((double)1.0, (double)1.0, (double)7.0, (double)15.0, (double)3.0, (double)9.0)});
        RopeBlock.SHAPE_BOTTOM[Rungs.X.ordinal()] = Shapes.m_83110_((VoxelShape)rope_core_bottom, (VoxelShape)rope_rungs_x);
        RopeBlock.SHAPE[Rungs.Z.ordinal()] = Shapes.m_83124_((VoxelShape)rope_core, (VoxelShape[])new VoxelShape[]{rope_rungs_z, Block.m_49796_((double)7.0, (double)1.0, (double)1.0, (double)9.0, (double)3.0, (double)15.0)});
        RopeBlock.SHAPE_BOTTOM[Rungs.Z.ordinal()] = Shapes.m_83110_((VoxelShape)rope_core_bottom, (VoxelShape)rope_rungs_z);
    }

    public static enum Rungs implements StringRepresentable
    {
        NONE,
        X,
        Z;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.US);
        }

        public static Rungs fromAxis(Direction.Axis axis) {
            return switch (axis) {
                case Direction.Axis.X -> X;
                case Direction.Axis.Z -> Z;
                default -> NONE;
            };
        }
    }
}

