/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CarpetedTrapdoorBlock
extends TrapDoorBlock
implements IHidable {
    private static final VoxelShape EAST_OPEN_CARP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_OPEN_CARP_AABB = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_OPEN_CARP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
    private static final VoxelShape NORTH_OPEN_CARP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape BOTTOM_CARP_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final VoxelShape TOP_CARP_AABB = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.9, (double)16.0);

    public CarpetedTrapdoorBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60978_(3.0f).m_60918_(SoundType.f_56745_));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean isTop;
        boolean bl = isTop = state.m_61143_((Property)f_57515_) == Half.TOP;
        if (!((Boolean)state.m_61143_((Property)f_57514_)).booleanValue()) {
            return isTop ? TOP_CARP_AABB : BOTTOM_CARP_AABB;
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            default -> {
                if (isTop) {
                    yield NORTH_OPEN_CARP_AABB;
                }
                yield f_57521_;
            }
            case Direction.SOUTH -> {
                if (isTop) {
                    yield SOUTH_OPEN_CARP_AABB;
                }
                yield f_57520_;
            }
            case Direction.WEST -> {
                if (isTop) {
                    yield WEST_OPEN_CARP_AABB;
                }
                yield f_57519_;
            }
            case Direction.EAST -> isTop ? EAST_OPEN_CARP_AABB : f_57518_;
        };
    }

    @Override
    public boolean isEnabled() {
        return Config.enableCarpetedTrapdoor.getAsBoolean();
    }
}

