/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.client;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.library.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class PortalColorHandler
implements BlockColor {
    private static final int DEFAULT_COLOR = 10037503;
    private static final Set<Block> BEACON_COLOR_BLACKLIST = new HashSet<Block>();
    public static final PortalColorHandler INSTANCE = new PortalColorHandler();

    private PortalColorHandler() {
    }

    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter world, @Nullable BlockPos pos, int tintValue) {
        BlockPos above;
        if (!((Boolean)Config.customPortalColor.get()).booleanValue()) {
            return -1;
        }
        if (world == null || pos == null) {
            return 10037503;
        }
        if (world instanceof RenderChunkRegion) {
            world = ((RenderChunkRegion)world).f_112908_;
        }
        if (pos.m_123342_() % 16 == 15 && world.m_8055_(above = pos.m_7494_()).m_60734_() == Blocks.f_50142_) {
            Minecraft mc = Minecraft.m_91087_();
            BlockAndTintGetter blockGetter = world;
            mc.m_18689_(() -> PortalColorHandler.lambda$getColor$0(mc, (BlockGetter)blockGetter, above, state));
        }
        pos = pos.m_7495_();
        while (world.m_8055_(pos).m_60734_() == Blocks.f_50142_) {
            pos = pos.m_7495_();
        }
        return PortalColorHandler.getColorValue(world, pos.m_7495_());
    }

    private static int getColorValue(BlockAndTintGetter access, BlockPos pos) {
        BlockState state = access.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BeaconBeamBlock) {
            BeaconBeamBlock beacon = (BeaconBeamBlock)block;
            return MiscUtil.getColor(beacon.m_7988_());
        }
        if (!BEACON_COLOR_BLACKLIST.contains(block) && access instanceof LevelReader) {
            LevelReader world = (LevelReader)access;
            try {
                float[] color = block.getBeaconColorMultiplier(state, world, pos, pos);
                if (color != null && color.length == 3) {
                    return MiscUtil.getColorInteger(color);
                }
            }
            catch (ClassCastException e) {
                Inspirations.log.error("Error getting beacon color for block", (Throwable)e);
                BEACON_COLOR_BLACKLIST.add(block);
            }
        }
        return 10037503;
    }

    private static /* synthetic */ void lambda$getColor$0(Minecraft mc, BlockGetter blockGetter, BlockPos above, BlockState state) {
        mc.f_91060_.m_109544_(blockGetter, above, state, state, 8);
    }
}

