/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.item;

import com.mojang.serialization.DynamicOps;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import org.apache.logging.log4j.Logger;

public class DimensionCompassItem
extends CompassItem
implements DyeableLeatherItem,
IHidable {
    public DimensionCompassItem(Item.Properties builder) {
        super(builder);
    }

    @Override
    public boolean isEnabled() {
        return Config.enableDimensionCompass.getAsBoolean();
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.m_6787_(group, items);
        }
    }

    public String m_5671_(ItemStack stack) {
        return DimensionCompassItem.m_40736_((ItemStack)stack) ? "item.inspirations.lodestone_dimension_compass" : this.m_5524_();
    }

    public InteractionResult m_6225_(UseOnContext context) {
        boolean singleItem;
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        if (!world.m_8055_(blockpos).m_60713_(Blocks.f_50729_)) {
            return InteractionResult.PASS;
        }
        world.m_5594_(null, blockpos, SoundEvents.f_12107_, SoundSource.PLAYERS, 1.0f, 1.0f);
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        boolean bl = singleItem = !player.m_150110_().f_35937_ && stack.m_41613_() == 1;
        if (singleItem) {
            DimensionCompassItem.write((ResourceKey<Level>)world.m_46472_(), blockpos, stack.m_41784_());
        } else {
            ItemStack copy = new ItemStack((ItemLike)this, 1);
            CompoundTag nbt = stack.m_41783_();
            nbt = nbt == null ? new CompoundTag() : nbt.m_6426_();
            copy.m_41751_(nbt);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            DimensionCompassItem.write((ResourceKey<Level>)world.m_46472_(), blockpos, nbt);
            if (!player.m_150109_().m_36054_(copy)) {
                player.m_36176_(copy, false);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    private static void write(ResourceKey<Level> dimension, BlockPos pos, CompoundTag nbt) {
        nbt.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, dimension).resultOrPartial(arg_0 -> ((Logger)Inspirations.log).error(arg_0)).ifPresent(key -> nbt.m_128365_("LodestoneDimension", key));
        nbt.m_128379_("LodestoneTracked", true);
    }
}

