/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.network;

import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.network.CauldronColorUpdatePacket;
import knightminer.inspirations.common.network.CauldronPotionUpdatePacket;
import knightminer.inspirations.common.network.DimensionCompassPositionPacket;
import knightminer.inspirations.common.network.InventorySlotSyncPacket;
import knightminer.inspirations.common.network.MilkablePacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import slimeknights.mantle.network.NetworkWrapper;
import slimeknights.mantle.network.packet.ISimplePacket;

public class InspirationsNetwork
extends NetworkWrapper {
    public static final InspirationsNetwork INSTANCE = new InspirationsNetwork();

    private InspirationsNetwork() {
        super(Inspirations.getResource("network"));
    }

    public void setup() {
        this.registerPacket(InventorySlotSyncPacket.class, InventorySlotSyncPacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(MilkablePacket.class, MilkablePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(CauldronColorUpdatePacket.class, CauldronColorUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(CauldronPotionUpdatePacket.class, CauldronPotionUpdatePacket::new, NetworkDirection.PLAY_TO_CLIENT);
        this.registerPacket(DimensionCompassPositionPacket.class, DimensionCompassPositionPacket::new, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendPacket(Entity player, Packet<?> packet) {
        INSTANCE.sendVanillaPacket(packet, player);
    }

    public static void sendToClients(@Nullable Level world, BlockPos pos, ISimplePacket packet) {
        if (world instanceof ServerLevel) {
            InspirationsNetwork.sendToClients((ServerLevel)world, pos, packet);
        }
    }

    public static void sendToClients(ServerLevel world, BlockPos pos, ISimplePacket packet) {
        INSTANCE.sendToClientsAround(packet, world, pos);
    }
}

