/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.client;

import com.mojang.blaze3d.vertex.PoseStack;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.building.block.entity.ShelfInventory;
import knightminer.inspirations.building.block.menu.ShelfContainerMenu;
import knightminer.inspirations.common.client.BackgroundContainerScreen;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.client.ClientUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import slimeknights.mantle.client.screen.ElementScreen;

public class ShelfContainerScreen
extends BackgroundContainerScreen<ShelfContainerMenu> {
    private static final ElementScreen SLOT_COVER = new ElementScreen(176, 0, 18, 18, 256, 256);
    private static final ElementScreen BOOK_SLOT_ICON = new ElementScreen(176, 18, 16, 16, 256, 256);

    public ShelfContainerScreen(ShelfContainerMenu container, Inventory inventory, Component name) {
        super(container, inventory, name, 156, Inspirations.getResource("textures/gui/shelf.png"));
    }

    private void checkBookIcon(PoseStack matrixStack, ShelfInventory inventory, int index) {
        if (inventory.getStackInSlot(index).m_41619_() && (index % 8 == 7 || !inventory.getStackInSlot(index + 1).m_41619_())) {
            Slot slot = ((ShelfContainerMenu)this.m_6262_()).m_38853_(index);
            BOOK_SLOT_ICON.draw(matrixStack, this.f_97735_ + slot.f_40220_, this.f_97736_ + slot.f_40221_);
        }
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        ShelfBlockEntity shelf = (ShelfBlockEntity)((ShelfContainerMenu)this.m_6262_()).getTile();
        if (shelf != null) {
            ShelfInventory inventory = shelf.getInventory();
            for (int i = 0; i < 16; ++i) {
                this.checkBookIcon(matrixStack, inventory, i);
            }
        }
    }

    private void checkCoverSlot(PoseStack matrixStack, ShelfInventory inventory, int index) {
        ItemStack previous;
        if (inventory.getStackInSlot(index).m_41619_() && !(previous = inventory.getStackInSlot(index - 1)).m_41619_() && !InspirationsRegistry.isBook(previous)) {
            Slot slot = ((ShelfContainerMenu)this.m_6262_()).m_38853_(index);
            SLOT_COVER.draw(matrixStack, slot.f_40220_ - 1, slot.f_40221_ - 1);
        }
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        ShelfBlockEntity shelf = (ShelfBlockEntity)((ShelfContainerMenu)this.m_6262_()).getTile();
        if (shelf != null) {
            int i;
            ShelfInventory inventory = shelf.getInventory();
            ClientUtil.bindTexture(this.background);
            for (i = 1; i < 8; ++i) {
                this.checkCoverSlot(matrixStack, inventory, i);
            }
            for (i = 9; i < 16; ++i) {
                this.checkCoverSlot(matrixStack, inventory, i);
            }
        }
    }
}

