/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import java.util.function.Supplier;
import knightminer.inspirations.building.block.ClimbablePaneBlock;
import knightminer.inspirations.building.block.EnlightenedBushBlock;
import knightminer.inspirations.building.block.GlassDoorBlock;
import knightminer.inspirations.building.block.GlassTrapdoorBlock;
import knightminer.inspirations.building.block.GrowableFlowerBlock;
import knightminer.inspirations.building.block.MulchBlock;
import knightminer.inspirations.building.block.PathBlock;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.building.block.ShelfBlock;
import knightminer.inspirations.building.block.entity.EnlightenedBushBlockEntity;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.building.block.menu.ShelfContainerMenu;
import knightminer.inspirations.building.block.type.BushType;
import knightminer.inspirations.building.block.type.FlowerType;
import knightminer.inspirations.building.block.type.MulchType;
import knightminer.inspirations.building.block.type.PathType;
import knightminer.inspirations.building.block.type.ShelfType;
import knightminer.inspirations.building.datagen.BuildingRecipeProvider;
import knightminer.inspirations.building.item.GlassDoorBlockItem;
import knightminer.inspirations.building.item.ShelfItem;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.DyeableItem;
import knightminer.inspirations.common.item.HidableBlockItem;
import knightminer.inspirations.common.item.HidableItem;
import knightminer.inspirations.common.item.HidableRetexturedBlockItem;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ContainerTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsBuilding
extends ModuleBase {
    public static RopeBlock rope;
    public static RopeBlock vine;
    public static Block glassDoor;
    public static Block glassTrapdoor;
    public static EnumObject<ShelfType, ShelfBlock> shelf;
    public static EnumObject<MulchType, MulchBlock> mulch;
    public static EnumObject<PathType, PathBlock> path;
    public static EnumObject<BushType, EnlightenedBushBlock> enlightenedBush;
    public static EnumObject<FlowerType, GrowableFlowerBlock> flower;
    public static EnumObject<FlowerType, FlowerPotBlock> flowerPot;
    public static Block ironBars;
    public static Item glassDoorItem;
    public static Item redstoneBook;
    public static Item coloredBook;
    public static BlockEntityType<ShelfBlockEntity> shelfTileEntity;
    public static BlockEntityType<EnlightenedBushBlockEntity> enlightenedBushTileEntity;
    public static MenuType<ShelfContainerMenu> shelfContainer;

    @SubscribeEvent
    void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey == Registry.f_122907_) {
            BlockEntityTypeRegistryAdapter registry = new BlockEntityTypeRegistryAdapter(ForgeRegistries.BLOCK_ENTITY_TYPES);
            shelfTileEntity = registry.register(ShelfBlockEntity::new, shelf, "bookshelf");
            enlightenedBushTileEntity = registry.register(EnlightenedBushBlockEntity::new, enlightenedBush, "enlightened_bush");
        } else if (registryKey == Registry.f_122913_) {
            ContainerTypeRegistryAdapter registry = new ContainerTypeRegistryAdapter(ForgeRegistries.MENU_TYPES);
            shelfContainer = registry.registerType(ShelfContainerMenu::new, "shelf");
        } else if (registryKey == Registry.f_122901_) {
            BlockRegistryAdapter registry = new BlockRegistryAdapter(ForgeRegistries.BLOCKS);
            BlockBehaviour.Properties shelfProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, 5.0f).m_60918_(SoundType.f_56736_).m_60955_();
            shelf = new EnumObject.Builder(ShelfType.class).put((Enum)ShelfType.NORMAL, (Object)((ShelfBlock)registry.register((Object)new ShelfBlock(shelfProps), "shelf"))).putAll(registry.registerEnum(type -> new ShelfBlock(shelfProps), (Enum[])ShelfType.FANCY, "shelf")).build();
            rope = (RopeBlock)registry.register((Object)new RopeBlock(Items.f_42398_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76370_).m_60918_(SoundType.f_56745_).m_60978_(0.5f)), "rope");
            vine = (RopeBlock)registry.register((Object)new RopeBlock(Items.f_41911_, BlockBehaviour.Properties.m_60944_((Material)Material.f_76299_, (MaterialColor)MaterialColor.f_76405_).m_60918_(SoundType.f_56740_).m_60978_(0.5f)), "vine");
            if (((Boolean)Config.climbableIronBars.get()).booleanValue()) {
                ironBars = (Block)registry.register((Object)new ClimbablePaneBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76398_).m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_)), new ResourceLocation("iron_bars"));
            }
            BlockBehaviour.Properties glassDoorProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.3f).m_60918_(SoundType.f_56744_).m_60955_();
            glassDoor = (Block)registry.register((Object)new GlassDoorBlock(glassDoorProps), "glass_door");
            glassTrapdoor = (Block)registry.register((Object)new GlassTrapdoorBlock(glassDoorProps), "glass_trapdoor");
            mulch = registry.registerEnum(type -> new MulchBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)type.getColor()).m_60918_(SoundType.f_56752_).m_60978_(0.6f)), (Enum[])MulchType.values(), "mulch");
            path = registry.registerEnum(type -> new PathBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)type.getColor()).m_60913_(1.5f, 10.0f), type.getShape()), (Enum[])PathType.values(), "path");
            enlightenedBush = registry.registerEnum(type -> new EnlightenedBushBlock(type.getColor()), (Enum[])BushType.values(), "enlightened_bush");
            BlockBehaviour.Properties flowerProps = BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60978_(0.0f).m_60918_(SoundType.f_56740_).m_60910_();
            flower = new EnumObject.Builder(FlowerType.class).put((Enum)FlowerType.CYAN, (Object)((GrowableFlowerBlock)registry.register((Object)new GrowableFlowerBlock(MobEffects.f_19591_, 4, null, flowerProps), "cyan_flower"))).put((Enum)FlowerType.SYRINGA, (Object)((GrowableFlowerBlock)registry.register((Object)new GrowableFlowerBlock(MobEffects.f_19612_, 8, (DoublePlantBlock)Blocks.f_50356_, flowerProps), "syringa"))).put((Enum)FlowerType.PAEONIA, (Object)((GrowableFlowerBlock)registry.register((Object)new GrowableFlowerBlock(MobEffects.f_19608_, 5, (DoublePlantBlock)Blocks.f_50358_, flowerProps), "paeonia"))).put((Enum)FlowerType.ROSE, (Object)((GrowableFlowerBlock)registry.register((Object)new GrowableFlowerBlock(MobEffects.f_19598_, 7, (DoublePlantBlock)Blocks.f_50357_, flowerProps), "rose"))).build();
            Supplier<FlowerPotBlock> emptyPot = () -> (FlowerPotBlock)Blocks.f_50276_;
            FlowerPotBlock vanillaPot = (FlowerPotBlock)Blocks.f_50276_;
            BlockBehaviour.Properties props = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50276_);
            flowerPot = registry.registerEnum(type -> {
                Block plant = (Block)flower.get((Enum)type);
                FlowerPotBlock pot = new FlowerPotBlock(emptyPot, () -> plant, props);
                vanillaPot.addPlant(Registry.f_122824_.m_7981_((Object)plant), () -> pot);
                return pot;
            }, "potted", (Enum[])FlowerType.values());
        } else if (registryKey == Registry.f_122904_) {
            ItemRegistryAdapter registry = new ItemRegistryAdapter(ForgeRegistries.ITEMS);
            Item.Properties materialProps = new Item.Properties().m_41491_(CreativeModeTab.f_40759_);
            Item.Properties decorationProps = new Item.Properties().m_41491_(CreativeModeTab.f_40750_);
            Item.Properties buildingProps = new Item.Properties().m_41491_(CreativeModeTab.f_40749_);
            Item.Properties redstoneProps = new Item.Properties().m_41491_(CreativeModeTab.f_40751_);
            coloredBook = (Item)registry.register((Object)new DyeableItem(materialProps, Config.enableColoredBooks), "colored_book");
            redstoneBook = (Item)registry.register((Object)new HidableItem(materialProps, Config.enableRedstoneBook), "redstone_book");
            registry.registerBlockItem(shelf, ShelfItem::new);
            registry.registerBlockItem((Block)rope, decorationProps);
            registry.registerBlockItem((Block)vine, decorationProps);
            if (ironBars != null) {
                registry.registerBlockItem(ironBars, decorationProps);
            }
            registry.registerBlockItem(mulch, buildingProps);
            registry.registerBlockItem(path, decorationProps);
            registry.registerBlockItem(flower, decorationProps);
            registry.registerBlockItem(enlightenedBush, bush -> new HidableRetexturedBlockItem((Block)bush, (TagKey<Item>)ItemTags.f_13143_, decorationProps));
            glassDoorItem = (Item)registry.register((Object)new GlassDoorBlockItem(glassDoor, redstoneProps), Registry.f_122824_.m_7981_((Object)glassDoor));
            registry.registerBlockItem((BlockItem)new HidableBlockItem(glassTrapdoor, redstoneProps));
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(event.includeServer(), (DataProvider)new BuildingRecipeProvider(gen));
    }

    @SubscribeEvent
    void init(FMLCommonSetupEvent event) {
        event.enqueueWork(InspirationsBuilding::registerCompostables);
    }

    @SubscribeEvent
    public static void loadLoad(LootTableLoadEvent event) {
        flower.forEach((type, plant) -> {
            if (type != FlowerType.CYAN) {
                plant.injectLoot(event);
            }
        });
    }

    private static void registerCompostables() {
        for (Block bush : enlightenedBush.values()) {
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)bush);
        }
        ComposterBlock.m_51920_((float)0.5f, (ItemLike)vine);
        for (Block plant : flower.values()) {
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)plant);
        }
    }

    static {
        shelf = EnumObject.empty();
        mulch = EnumObject.empty();
        path = EnumObject.empty();
        enlightenedBush = EnumObject.empty();
        flower = EnumObject.empty();
        flowerPot = EnumObject.empty();
    }
}

