/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import knightminer.inspirations.common.InspirationsCommons;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CarpetedPressurePlateBlock
extends PressurePlateBlock {
    private static final VoxelShape PRESSED_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.25, (double)15.0));
    private static final VoxelShape UNPRESSED_AABB = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)1.5, (double)15.0));
    private final DyeColor color;
    private final String transKey;

    public CarpetedPressurePlateBlock(DyeColor color) {
        super(PressurePlateBlock.Sensitivity.MOBS, BlockBehaviour.Properties.m_60941_((Material)Material.f_76299_, (DyeColor)color).m_60978_(0.5f).m_60918_(SoundType.f_56745_));
        this.color = color;
        this.transKey = String.format("block.minecraft.%s_carpet", color.m_41065_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean flag = this.m_6016_(state) > 0;
        return flag ? PRESSED_AABB : UNPRESSED_AABB;
    }

    public String m_7705_() {
        return this.transKey;
    }

    public ItemLike getCarpet() {
        return (ItemLike)InspirationsCommons.VANILLA_CARPETS.get((Enum)this.color);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack(this.getCarpet());
    }
}

