/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility;

import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.common.item.HidableBlockItem;
import knightminer.inspirations.utility.block.CarpetedPressurePlateBlock;
import knightminer.inspirations.utility.block.CarpetedTrapdoorBlock;
import knightminer.inspirations.utility.block.CollectorBlock;
import knightminer.inspirations.utility.block.PipeBlock;
import knightminer.inspirations.utility.block.TorchLeverBlock;
import knightminer.inspirations.utility.block.TorchLeverWallBlock;
import knightminer.inspirations.utility.block.entity.CollectorBlockEntity;
import knightminer.inspirations.utility.block.entity.PipeBlockEntity;
import knightminer.inspirations.utility.block.menu.CollectorContainerMenu;
import knightminer.inspirations.utility.block.menu.PipeContainerMenu;
import knightminer.inspirations.utility.datagen.UtilityRecipeProvider;
import knightminer.inspirations.utility.item.TorchLeverItem;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.ContainerTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsUtility
extends ModuleBase {
    public static Block torchLeverWall;
    public static Block torchLeverFloor;
    public static Block soulLeverWall;
    public static Block soulLeverFloor;
    public static EnumObject<DyeColor, CarpetedTrapdoorBlock> carpetedTrapdoors;
    public static EnumObject<DyeColor, CarpetedPressurePlateBlock> carpetedPressurePlates;
    public static Block collector;
    public static Block pipe;
    public static Item torchLeverItem;
    public static Item soulLeverItem;
    public static BlockEntityType<CollectorBlockEntity> tileCollector;
    public static BlockEntityType<PipeBlockEntity> tilePipe;
    public static MenuType<CollectorContainerMenu> contCollector;
    public static MenuType<PipeContainerMenu> contPipe;

    @SubscribeEvent
    public void register(RegisterEvent event) {
        ResourceKey resourceKey = event.getRegistryKey();
        if (resourceKey == Registry.f_122901_) {
            BlockRegistryAdapter registry = new BlockRegistryAdapter(ForgeRegistries.BLOCKS);
            torchLeverFloor = (Block)registry.register((Object)new TorchLeverBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50081_).m_60918_(SoundType.f_56736_), (ParticleOptions)ParticleTypes.f_123744_), "torch_lever");
            torchLeverWall = (Block)registry.register((Object)new TorchLeverWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50082_).lootFrom(() -> torchLeverFloor), (ParticleOptions)ParticleTypes.f_123744_), "wall_torch_lever");
            soulLeverFloor = (Block)registry.register((Object)new TorchLeverBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50139_), (ParticleOptions)ParticleTypes.f_123745_), "soul_torch_lever");
            soulLeverWall = (Block)registry.register((Object)new TorchLeverWallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50140_).lootFrom(() -> soulLeverFloor), (ParticleOptions)ParticleTypes.f_123745_), "wall_soul_torch_lever");
            carpetedTrapdoors = registry.registerEnum(color -> new CarpetedTrapdoorBlock(), (Enum[])DyeColor.values(), "carpeted_trapdoor");
            carpetedPressurePlates = registry.registerEnum(CarpetedPressurePlateBlock::new, (Enum[])DyeColor.values(), "carpeted_pressure_plate");
            collector = (Block)registry.register((Object)new CollectorBlock(), "collector");
            pipe = (Block)registry.register((Object)new PipeBlock(), "pipe");
        } else if (resourceKey == Registry.f_122907_) {
            BlockEntityTypeRegistryAdapter registry = new BlockEntityTypeRegistryAdapter(ForgeRegistries.BLOCK_ENTITY_TYPES);
            tileCollector = registry.register(CollectorBlockEntity::new, collector, "collector");
            tilePipe = registry.register(PipeBlockEntity::new, pipe, "pipe");
        } else if (resourceKey == Registry.f_122913_) {
            ContainerTypeRegistryAdapter registry = new ContainerTypeRegistryAdapter(ForgeRegistries.MENU_TYPES);
            contCollector = registry.registerType(CollectorContainerMenu::new, "collector");
            contPipe = registry.registerType(PipeContainerMenu::new, "pipe");
        } else if (resourceKey == Registry.f_122904_) {
            Item.Properties props = new Item.Properties().m_41491_(CreativeModeTab.f_40751_);
            ItemRegistryAdapter registry = new ItemRegistryAdapter(ForgeRegistries.ITEMS, props);
            torchLeverItem = (Item)registry.register((Object)new TorchLeverItem(torchLeverFloor, torchLeverWall, props), "torch_lever");
            soulLeverItem = (Item)registry.register((Object)new TorchLeverItem(soulLeverFloor, soulLeverWall, props), "soul_torch_lever");
            registry.registerBlockItem(carpetedTrapdoors, block -> new HidableBlockItem((Block)block, props));
            registry.registerDefaultBlockItem(collector);
            registry.registerDefaultBlockItem(pipe);
        }
    }

    @SubscribeEvent
    public void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(event.includeServer(), (DataProvider)new UtilityRecipeProvider(gen));
    }

    static {
        carpetedTrapdoors = EnumObject.empty();
        carpetedPressurePlates = EnumObject.empty();
    }
}

