/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class TrimModel
implements IUnbakedGeometry<TrimModel> {
    public static final IGeometryLoader<TrimModel> LOADER = TrimModel::readModel;
    private final SimpleBlockModel model;
    private final float trim;

    public TrimModel(SimpleBlockModel model, float trim) {
        this.model = model;
        this.trim = trim;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getMaterials(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        List originalElements = this.model.getElements();
        HashMap<Pair, Float> highest = new HashMap<Pair, Float>();
        HashMap<Pair, BlockElementFace> topFaces = new HashMap<Pair, BlockElementFace>();
        for (BlockElement part : originalElements) {
            Pair xz = Pair.of((Object)Float.valueOf(part.f_111308_.m_122239_()), (Object)Float.valueOf(part.f_111308_.m_122269_()));
            float height = part.f_111309_.m_122260_();
            BlockElementFace face = (BlockElementFace)part.f_111310_.get(Direction.UP);
            if (highest.containsKey(xz)) {
                boolean isHighest;
                boolean bl = isHighest = height > ((Float)highest.get(xz)).floatValue();
                if (isHighest) {
                    highest.put(xz, Float.valueOf(height));
                }
                if ((face == null || !isHighest) && topFaces.containsKey(xz)) continue;
                topFaces.put(xz, face);
                continue;
            }
            highest.put(xz, Float.valueOf(height));
            if (face == null) continue;
            topFaces.put(xz, face);
        }
        ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
        for (BlockElement part : originalElements) {
            BlockElementFace topFace;
            float oldHeight;
            Pair xz = Pair.of((Object)Float.valueOf(part.f_111308_.m_122239_()), (Object)Float.valueOf(part.f_111308_.m_122269_()));
            float newHeight = ((Float)highest.get(xz)).floatValue() - this.trim;
            if (newHeight == 0.0f) {
                newHeight = 0.05f;
            }
            if (newHeight > (oldHeight = part.f_111309_.m_122260_())) {
                elements.add(part);
                continue;
            }
            Vector3f to = new Vector3f(part.f_111309_.m_122239_(), newHeight, part.f_111309_.m_122269_());
            float trimAmount = oldHeight - newHeight;
            if (!(to.m_122260_() >= part.f_111308_.m_122260_())) continue;
            boolean zeroHeight = to.m_122260_() == part.f_111308_.m_122260_();
            EnumMap<Direction, BlockElementFace> faces = new EnumMap<Direction, BlockElementFace>(Direction.class);
            for (Map.Entry entry : part.f_111310_.entrySet()) {
                boolean isY;
                Direction side = (Direction)entry.getKey();
                boolean bl = isY = side.m_122434_() == Direction.Axis.Y;
                if (zeroHeight && !isY) continue;
                if (isY) {
                    faces.put(side, (BlockElementFace)entry.getValue());
                    continue;
                }
                faces.put(side, TrimModel.trimUV((BlockElementFace)entry.getValue(), trimAmount));
            }
            if (!faces.containsKey(Direction.UP) && (topFace = (BlockElementFace)topFaces.get(xz)) != null) {
                faces.put(Direction.UP, topFace);
            }
            elements.add(new BlockElement(part.f_111308_, to, faces, part.f_111311_, part.f_111312_));
        }
        return SimpleBlockModel.bakeModel((IGeometryBakingContext)owner, elements, spriteGetter, (ModelState)transform, (ItemOverrides)overrides, (ResourceLocation)location);
    }

    private static BlockElementFace trimUV(BlockElementFace face, float amount) {
        BlockFaceUV uv = face.f_111357_;
        if (uv.f_111387_ == null) {
            return face;
        }
        float[] uvs = Arrays.copyOf(uv.f_111387_, 4);
        switch (uv.f_111388_) {
            case 0: {
                TrimModel.trim(uvs, amount, 1, 3);
                break;
            }
            case 180: {
                TrimModel.trim(uvs, amount, 3, 1);
                break;
            }
            case 90: {
                TrimModel.trim(uvs, amount, 0, 2);
                break;
            }
            case 270: {
                TrimModel.trim(uvs, amount, 2, 0);
            }
        }
        return new BlockElementFace(face.f_111354_, face.f_111355_, face.f_111356_, new BlockFaceUV(uvs, uv.f_111388_));
    }

    private static void trim(float[] uvs, float amount, int index, int compare) {
        if (uvs[index] > uvs[compare]) {
            int n = index;
            uvs[n] = uvs[n] - amount;
        } else {
            int n = index;
            uvs[n] = uvs[n] + amount;
        }
    }

    public static TrimModel readModel(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        float trim = GsonHelper.m_13915_((JsonObject)json, (String)"trim");
        if (trim <= 0.0f) {
            throw new JsonSyntaxException("trim must be greater than 0");
        }
        return new TrimModel(model, trim);
    }
}

