/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.library.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.RetexturedModel;
import slimeknights.mantle.client.model.inventory.ModelItem;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.client.model.util.SimpleBlockModel;
import slimeknights.mantle.item.RetexturedBlockItem;
import slimeknights.mantle.util.RetexturedHelper;

public class ShelfModel
implements IUnbakedGeometry<ShelfModel> {
    public static final IGeometryLoader<ShelfModel> LOADER = ShelfModel::readModel;
    private final SimpleBlockModel model;
    private final Set<String> retextured;
    private final List<List<BlockElement>> books;
    private final List<ModelItem> items;

    protected ShelfModel(SimpleBlockModel model, Set<String> retextured, List<List<BlockElement>> books, List<ModelItem> items) {
        this.model = model;
        this.retextured = retextured;
        this.books = books;
        this.items = items;
    }

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.model.fetchParent(owner, modelGetter);
        ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
        this.books.forEach(elements::addAll);
        return SimpleBlockModel.getTextures((IGeometryBakingContext)owner, (List)elements, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transforms, ItemOverrides overrides, ResourceLocation location) {
        Shelf model = new Shelf(owner, this.model, transforms, this.books);
        BakedModel baked = model.bake(spriteGetter, location);
        return new Baked(baked, model, RetexturedModel.getAllRetextured((IGeometryBakingContext)owner, (SimpleBlockModel)this.model, this.retextured), this.items);
    }

    public static ShelfModel readModel(JsonObject json, JsonDeserializationContext context) {
        SimpleBlockModel model = SimpleBlockModel.deserialize((JsonObject)json, (JsonDeserializationContext)context);
        Set retextured = RetexturedModel.getRetexturedNames((JsonObject)json);
        JsonArray bookArray = GsonHelper.m_13933_((JsonObject)json, (String)"books");
        if (bookArray.size() == 0) {
            throw new JsonSyntaxException("Must have at least one book element");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < bookArray.size(); ++i) {
            builder.add((Object)SimpleBlockModel.getModelElements((JsonDeserializationContext)context, (JsonElement)bookArray.get(i), (String)("books[" + i + "]")));
        }
        List items = ModelItem.listFromJson((JsonObject)json, (String)"items");
        return new ShelfModel(model, retextured, (List<List<BlockElement>>)builder.build(), items);
    }

    private static class Shelf {
        private final IGeometryBakingContext owner;
        private final SimpleBlockModel model;
        private final ModelState transform;
        private final List<List<BlockElement>> books;
        private BakedModel baked;

        private Shelf(IGeometryBakingContext owner, SimpleBlockModel model, ModelState transform, List<List<BlockElement>> books) {
            this.owner = owner;
            this.model = model;
            this.transform = transform;
            this.books = books;
        }

        public BakedModel bake(Function<Material, TextureAtlasSprite> spriteGetter, ResourceLocation location) {
            ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
            this.books.forEach(elements::addAll);
            this.baked = SimpleBlockModel.bakeModel((IGeometryBakingContext)this.owner, (List)elements, spriteGetter, (ModelState)this.transform, (ItemOverrides)ItemOverrides.f_111734_, (ResourceLocation)location);
            return this.baked;
        }

        public BakedModel getBaked() {
            if (this.baked == null) {
                ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
                this.books.forEach(elements::addAll);
                this.baked = SimpleBlockModel.bakeDynamic((IGeometryBakingContext)this.owner, (List)elements, (ModelState)this.transform);
            }
            return this.baked;
        }

        public Shelf withTexture(Set<String> retextured, ResourceLocation texture) {
            return new Shelf((IGeometryBakingContext)new RetexturedModel.RetexturedContext(this.owner, retextured, texture), this.model, this.transform, this.books);
        }

        public BakedModel bakeWithBooks(int modelBooks) {
            ArrayList elements = Lists.newArrayList((Iterable)this.model.getElements());
            for (int i = 0; i < this.books.size(); ++i) {
                int flag = 1 << i;
                if ((modelBooks & flag) != flag) continue;
                elements.addAll((Collection)this.books.get(i));
            }
            return SimpleBlockModel.bakeDynamic((IGeometryBakingContext)this.owner, (List)elements, (ModelState)this.transform);
        }
    }

    public static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final Map<ResourceLocation, Shelf> texturedCache = new HashMap<ResourceLocation, Shelf>();
        private final Cache<BookshelfCacheKey, BakedModel> bookshelfCache = CacheBuilder.newBuilder().maximumSize(30L).build();
        private final Shelf model;
        private final Set<String> retextured;
        private final List<ModelItem> items;

        protected Baked(BakedModel baked, Shelf model, Set<String> retextured, List<ModelItem> items) {
            super(baked);
            this.model = model;
            this.retextured = retextured;
            this.items = items;
        }

        private Shelf getTexturedShelf(@Nullable ResourceLocation texture) {
            if (texture == null) {
                return this.model;
            }
            return this.texturedCache.computeIfAbsent(texture, location -> this.model.withTexture(this.retextured, (ResourceLocation)location));
        }

        private Shelf getTexturedShelf(Block texture) {
            return this.getTexturedShelf(ModelHelper.getParticleTexture((Block)texture));
        }

        public TextureAtlasSprite getParticleIcon(ModelData data) {
            Block block;
            if (this.retextured.contains("particle") && (block = (Block)data.get(RetexturedHelper.BLOCK_PROPERTY)) != null && block != Blocks.f_50016_) {
                return this.getTexturedShelf(block).getBaked().getParticleIcon(data);
            }
            return this.originalModel.getParticleIcon(data);
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction direction, RandomSource random, ModelData data, @Nullable RenderType renderType) {
            BakedModel finalModel;
            Integer books;
            if (data == ModelData.EMPTY) {
                return this.originalModel.getQuads(state, direction, random, data, renderType);
            }
            Block block = (Block)data.get(RetexturedHelper.BLOCK_PROPERTY);
            ResourceLocation texture = null;
            if (block != null && block != Blocks.f_50016_) {
                texture = ModelHelper.getParticleTexture((Block)block);
            }
            if ((books = (Integer)data.get(ShelfBlockEntity.BOOKS)) == null) {
                books = 0;
            }
            try {
                BookshelfCacheKey key = new BookshelfCacheKey(texture, books);
                finalModel = (BakedModel)this.bookshelfCache.get((Object)key, () -> this.getTexturedShelf(key.texture).bakeWithBooks(key.books));
            }
            catch (ExecutionException e) {
                Inspirations.log.error((Object)e);
                finalModel = this.originalModel;
            }
            return finalModel.getQuads(state, direction, random, data, renderType);
        }

        public ItemOverrides m_7343_() {
            return RetexturedOverride.INSTANCE;
        }

        public List<ModelItem> getItems() {
            return this.items;
        }
    }

    private static class BookshelfCacheKey {
        @Nullable
        protected ResourceLocation texture;
        protected int books;

        BookshelfCacheKey(@Nullable ResourceLocation texture, int books) {
            this.texture = texture;
            this.books = books;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BookshelfCacheKey that = (BookshelfCacheKey)o;
            return this.books == that.books && Objects.equals(this.texture, that.texture);
        }

        public int hashCode() {
            return (this.texture == null ? 0 : 31 * this.texture.hashCode()) + this.books;
        }
    }

    private static class RetexturedOverride
    extends ItemOverrides {
        private static final RetexturedOverride INSTANCE = new RetexturedOverride();

        private RetexturedOverride() {
        }

        @Nullable
        public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int seed) {
            if (stack.m_41619_() || !stack.m_41782_()) {
                return originalModel;
            }
            Block block = RetexturedBlockItem.getTexture((ItemStack)stack);
            if (block == Blocks.f_50016_) {
                return originalModel;
            }
            return ((Baked)originalModel).getTexturedShelf(block).getBaked();
        }
    }
}

