/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;

public class GrowableFlowerBlock
extends FlowerBlock
implements BonemealableBlock,
IHidable {
    private final DoublePlantBlock largePlant;

    public GrowableFlowerBlock(MobEffect effect, int duration, @Nullable DoublePlantBlock largePlant, BlockBehaviour.Properties props) {
        super(effect, duration, props);
        this.largePlant = largePlant;
    }

    @Override
    public boolean isEnabled() {
        return Config.enableFlowers.getAsBoolean();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.m_49811_(group, items);
        }
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return this.largePlant != null;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource pRandom, BlockPos pos, BlockState state) {
        if (this.largePlant == null) {
            return;
        }
        if (level.m_46859_(pos.m_7494_())) {
            DoublePlantBlock.m_153173_((LevelAccessor)level, (BlockState)this.largePlant.m_49966_(), (BlockPos)pos, (int)2);
        }
    }

    public void injectLoot(LootTableLoadEvent event) {
        if (this.largePlant == null || !event.getName().m_135827_().equals("minecraft") || !event.getName().m_135815_().equals("blocks/" + Registry.f_122824_.m_7981_((Object)this.largePlant).m_135815_())) {
            return;
        }
        LootTable table = event.getTable();
        if (table.removePool("main") == null) {
            return;
        }
        ResourceLocation location = Inspirations.getResource("blocks/inject/" + Registry.f_122824_.m_7981_((Object)this).m_135815_());
        table.addPool(new LootPool.Builder().name(location.toString()).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)location)).m_79082_());
    }
}

