/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tweaks.recipe;

import java.util.function.BooleanSupplier;
import knightminer.inspirations.common.IHidable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class NormalBrewingRecipe
implements IHidable,
IBrewingRecipe {
    private final BooleanSupplier enabled;
    private final Potion start;
    private final Ingredient catalyst;
    private final Potion output;

    public NormalBrewingRecipe(Potion start, Ingredient catalyst, Potion output, BooleanSupplier enabledFunc) {
        this.start = start;
        this.catalyst = catalyst;
        this.output = output;
        this.enabled = enabledFunc;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.getAsBoolean();
    }

    public Ingredient getCatalyst() {
        return this.catalyst;
    }

    public Potion getStart() {
        return this.start;
    }

    public Potion getOutput() {
        return this.output;
    }

    public boolean isInput(ItemStack input) {
        Item item = input.m_41720_();
        if (item == Items.f_42589_ || item == Items.f_42736_ || item == Items.f_42739_) {
            return PotionUtils.m_43579_((ItemStack)input) == this.start;
        }
        return false;
    }

    public boolean isIngredient(ItemStack ingredient) {
        return this.catalyst.test(ingredient);
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (!this.isEnabled()) {
            return ItemStack.f_41583_;
        }
        if (!this.catalyst.test(ingredient)) {
            return ItemStack.f_41583_;
        }
        Item item = input.m_41720_();
        if (this.isInput(input)) {
            return PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)item), (Potion)this.output);
        }
        return ItemStack.f_41583_;
    }
}

