/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.tools.client;

import javax.annotation.Nullable;
import knightminer.inspirations.tools.capability.DimensionCompass;
import knightminer.inspirations.tools.capability.IDimensionCompass;
import knightminer.inspirations.tools.client.Angle;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class DimensionCompassPropertyGetter
implements ItemPropertyFunction {
    private final Angle positionWobble = new Angle();
    private final Angle randomRotation = new Angle();

    public float m_141951_(ItemStack stack, @Nullable ClientLevel clientWorld, @Nullable LivingEntity living, int seed) {
        LivingEntity entity;
        Object object = entity = living != null ? living : stack.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        ClientLevel world = clientWorld;
        if (world == null) {
            world = entity.f_19853_;
        }
        BlockPos pos = CompassItem.m_40736_((ItemStack)stack) ? DimensionCompassPropertyGetter.getLodestonePosition((Level)world, stack.m_41784_()) : DimensionCompassPropertyGetter.getDimensionEntered((Entity)entity);
        long time = world.m_46467_();
        Vec3 entityPos = entity.m_20182_();
        if (pos != null && entityPos.m_82531_((double)pos.m_123341_() + 0.5, entityPos.m_7098_(), (double)pos.m_123343_() + 0.5) >= (double)1.0E-5f) {
            double wobbleRotation;
            boolean isPlayer = living instanceof Player && ((Player)living).m_7578_();
            double holderAngle = 0.0;
            if (isPlayer) {
                holderAngle = living.m_146908_();
            } else if (entity instanceof ItemFrame) {
                holderAngle = Angle.getFrameRotation((ItemFrame)entity);
            } else if (entity instanceof ItemEntity) {
                holderAngle = 180.0f - ((ItemEntity)entity).m_32008_(0.5f) / ((float)Math.PI * 2) * 360.0f;
            } else if (living != null) {
                holderAngle = living.f_20883_;
            }
            holderAngle = Mth.m_14109_((double)(holderAngle / 360.0), (double)1.0);
            double exactRotation = DimensionCompassPropertyGetter.getAngleToPosition(Vec3.m_82512_((Vec3i)pos), (Entity)entity) / 6.2831854820251465;
            if (isPlayer) {
                if (this.positionWobble.shouldUpdate(time)) {
                    this.positionWobble.wobble(time, 0.5 - (holderAngle - 0.25));
                }
                wobbleRotation = exactRotation + this.positionWobble.getRotation();
            } else {
                wobbleRotation = 0.5 - (holderAngle - 0.25 - exactRotation);
            }
            return Mth.m_14091_((float)((float)wobbleRotation), (float)1.0f);
        }
        if (this.randomRotation.shouldUpdate(time)) {
            this.randomRotation.wobble(time, Math.random());
        }
        double wobbleRotation = this.randomRotation.getRotation() + (double)((float)stack.hashCode() / 2.1474836E9f);
        return Mth.m_14091_((float)((float)wobbleRotation), (float)1.0f);
    }

    @Nullable
    private static BlockPos getDimensionEntered(Entity entity) {
        return entity.getCapability(DimensionCompass.CAPABILITY).resolve().map(IDimensionCompass::getEnteredPosition).orElse(null);
    }

    @Nullable
    private static BlockPos getLodestonePosition(Level world, CompoundTag nbt) {
        GlobalPos globalPos;
        boolean hasPos = nbt.m_128441_("LodestonePos");
        boolean hasDim = nbt.m_128441_("LodestoneDimension");
        if (hasPos && hasDim && (globalPos = CompassItem.m_220021_((CompoundTag)nbt)) != null) {
            ResourceKey storedDimension = globalPos.m_122640_();
            ResourceKey currentDimension = world.m_46472_();
            BlockPos pos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("LodestonePos"));
            if (storedDimension != currentDimension) {
                if (storedDimension == Level.f_46429_) {
                    return new BlockPos(pos.m_123341_() * 8, pos.m_123342_(), pos.m_123343_() * 8);
                }
                if (currentDimension == Level.f_46429_) {
                    return new BlockPos(Math.round((float)pos.m_123341_() / 8.0f), pos.m_123342_(), Math.round((float)pos.m_123343_() / 8.0f));
                }
            }
            return pos;
        }
        return null;
    }

    private static double getAngleToPosition(Vec3 target, Entity entity) {
        return Math.atan2(target.m_7094_() - entity.m_20189_(), target.m_7096_() - entity.m_20185_());
    }
}

