/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.datagen;

import java.util.Map;
import javax.annotation.Nonnull;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.building.block.RopeBlock;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.loot.function.RetexturedLootFunction;

public class InspirationsBlockLootTable
extends BlockLoot {
    @Nonnull
    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getEntries().stream().filter(entry -> {
            String ns = ((ResourceKey)entry.getKey()).m_135782_().m_135827_();
            return ns.equals("inspirations") || ns.equals("minecraft");
        }).map(Map.Entry::getValue).toList();
    }

    protected void addTables() {
        super.addTables();
        this.addBuilding();
        this.addRecipes();
        this.addTools();
        this.addTweaks();
        this.addUtility();
    }

    private void addBuilding() {
        InspirationsBuilding.shelf.values().forEach(block -> this.m_124175_((Block)block, this::droppingWithNameAndTexture));
        InspirationsBuilding.enlightenedBush.values().forEach(block -> this.m_124175_((Block)block, this::enlightenedBush));
        InspirationsBuilding.mulch.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).m_124288_(arg_0));
        InspirationsBuilding.path.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).m_124288_(arg_0));
        this.m_124272_(InspirationsBuilding.glassTrapdoor);
        this.m_124165_(InspirationsBuilding.glassDoor, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)InspirationsBuilding.glassDoor)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)InspirationsBuilding.glassDoor).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER))).m_79080_(f_124062_)));
        InspirationsBuilding.flower.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).m_124288_(arg_0));
        InspirationsBuilding.flowerPot.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).m_124252_(arg_0));
        this.m_124175_(InspirationsBuilding.rope, this::rope);
        this.m_124175_(InspirationsBuilding.vine, this::rope);
    }

    private void addRecipes() {
        this.m_124147_((Block)InspirationsCaudrons.beetrootSoupCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.mushroomStewCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.potatoSoupCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.rabbitStewCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.honeyCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.milkCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.dyeCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.potionCauldron, (ItemLike)Blocks.f_50256_);
        this.m_124147_((Block)InspirationsCaudrons.suspiciousStewCauldron, (ItemLike)Blocks.f_50256_);
    }

    private void addTools() {
        this.m_124165_(InspirationsTools.redstoneCharge, InspirationsBlockLootTable.m_124125_());
    }

    private void addTweaks() {
        if (Config.enableFittedCarpets.getAsBoolean()) {
            for (DyeColor color : DyeColor.values()) {
                this.registerRedirect((Block)InspirationsTweaks.fitCarpets.get((Enum)color), (Block)InspirationsTweaks.flatCarpets.get((Enum)color));
            }
        }
        this.m_124165_((Block)InspirationsTweaks.wetHopper, InspirationsBlockLootTable.m_124292_((Block)InspirationsTweaks.dryHopper));
        this.m_124147_((Block)InspirationsTweaks.sugarCane, (ItemLike)InspirationsTweaks.sugarCaneSeeds);
        this.m_124147_((Block)InspirationsTweaks.cactus, (ItemLike)InspirationsTweaks.cactusSeeds);
    }

    private void addUtility() {
        InspirationsUtility.carpetedTrapdoors.values().forEach(arg_0 -> ((InspirationsBlockLootTable)this).m_124288_(arg_0));
        InspirationsUtility.carpetedPressurePlates.forEach((color, plate) -> this.m_124165_((Block)plate, LootTable.m_79147_().m_79161_((LootPool.Builder)InspirationsBlockLootTable.m_236224_((ItemLike)plate, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)plate.getCarpet())))).m_79161_((LootPool.Builder)InspirationsBlockLootTable.m_236224_((ItemLike)plate, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41967_))))));
        this.m_124288_(InspirationsUtility.pipe);
        this.m_124288_(InspirationsUtility.collector);
        this.m_124147_(InspirationsUtility.torchLeverFloor, (ItemLike)InspirationsUtility.torchLeverItem);
        this.m_124147_(InspirationsUtility.soulLeverFloor, (ItemLike)InspirationsUtility.soulLeverItem);
    }

    private LootTable.Builder rope(Block block) {
        RopeBlock rope = (RopeBlock)block;
        return LootTable.m_79147_().m_79161_((LootPool.Builder)InspirationsBlockLootTable.m_236224_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)))).m_79161_((LootPool.Builder)InspirationsBlockLootTable.m_236221_((ItemLike)block, (FunctionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)rope.getRungsItem()).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f)))).m_79080_(LootItemBlockStatePropertyCondition.m_81769_((Block)rope).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(RopeBlock.RUNGS, (Comparable)((Object)RopeBlock.Rungs.NONE))).m_81807_())));
    }

    private LootTable.Builder enlightenedBush(Block bush) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)bush).m_79078_(RetexturedLootFunction::new)).m_79080_(f_124065_));
    }

    private LootTable.Builder droppingWithNameAndTexture(Block block) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)InspirationsBlockLootTable.m_236224_((ItemLike)block, (ConditionUserBuilder)LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNameFunction.m_80187_((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).m_79078_(RetexturedLootFunction::new))));
    }

    private void registerRedirect(Block block, Block originalBlock) {
        this.m_124165_(block, LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)originalBlock.m_60589_()))));
    }
}

