/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.common.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BooleanSupplier;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.InspirationsCommons;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class ConfigEnabledCondition
implements ICondition,
LootItemCondition {
    private static final ResourceLocation ID = Inspirations.getResource("config");
    private static final Map<String, ConfigEnabledCondition> PROPS = new HashMap<String, ConfigEnabledCondition>();
    private final String configName;
    private final BooleanSupplier supplier;
    public static final ConfigEnabledCondition MODULE_BUILDING = ConfigEnabledCondition.add("building_module", Config.buildingModule);
    public static final ConfigEnabledCondition MODULE_UTILITY = ConfigEnabledCondition.add("utility_module", Config.utilityModule);
    public static final ConfigEnabledCondition MODULE_TOOLS = ConfigEnabledCondition.add("tools_module", Config.toolsModule);
    public static final ConfigEnabledCondition MODULE_TWEAKS = ConfigEnabledCondition.add("tweaks_module", Config.tweaksModule);
    public static final ConfigEnabledCondition MODULE_RECIPES = ConfigEnabledCondition.add("recipes_module", Config.cauldronsModule);
    public static final ConfigEnabledCondition BOOKSHELF = ConfigEnabledCondition.add("bookshelf", Config.enableBookshelf);
    public static final ConfigEnabledCondition COLORED_BOOKS = ConfigEnabledCondition.add("colored_books", Config.enableColoredBooks);
    public static final ConfigEnabledCondition ENLIGHTENED_BUSH = ConfigEnabledCondition.add("enlightened_bush", Config.enableEnlightenedBush);
    public static final ConfigEnabledCondition FLOWERS = ConfigEnabledCondition.add("flowers", Config.enableFlowers);
    public static final ConfigEnabledCondition GLASS_DOOR = ConfigEnabledCondition.add("glass_door", Config.enableGlassDoor);
    public static final ConfigEnabledCondition MULCH = ConfigEnabledCondition.add("mulch", Config.enableMulch);
    public static final ConfigEnabledCondition PATH = ConfigEnabledCondition.add("path", Config.enablePath);
    public static final ConfigEnabledCondition ROPE = ConfigEnabledCondition.add("rope", Config.enableRope);
    public static final ConfigEnabledCondition CARPETED_TRAPDOOR = ConfigEnabledCondition.add("carpeted_trapdoor", Config.enableCarpetedTrapdoor);
    public static final ConfigEnabledCondition COLLECTOR = ConfigEnabledCondition.add("collector", Config.enableCollector);
    public static final ConfigEnabledCondition PIPE = ConfigEnabledCondition.add("pipe", Config.enablePipe);
    public static final ConfigEnabledCondition REDSTONE_BOOK = ConfigEnabledCondition.add("redstone_book", Config.enableRedstoneBook);
    public static final ConfigEnabledCondition TORCH_LEVER = ConfigEnabledCondition.add("torch_lever", Config.enableTorchLever);
    public static final ConfigEnabledCondition BAROMETER = ConfigEnabledCondition.add("barometer", Config.enableBarometer);
    public static final ConfigEnabledCondition CHARGED_ARROW = ConfigEnabledCondition.add("charged_arrow", Config.enableChargedArrow);
    public static final ConfigEnabledCondition DIMENSION_COMPASS = ConfigEnabledCondition.add("dimension_compass", Config.enableDimensionCompass);
    public static final ConfigEnabledCondition LOCK = ConfigEnabledCondition.add("lock", Config.enableLock);
    public static final ConfigEnabledCondition NORTH_COMPASS = ConfigEnabledCondition.add("north_compass", Config.enableNorthCompass);
    public static final ConfigEnabledCondition PHOTOMETER = ConfigEnabledCondition.add("photometer", Config.enablePhotometer);
    public static final ConfigEnabledCondition REDSTONE_CHARGER = ConfigEnabledCondition.add("redstone_charger", Config.enableRedstoneCharger);
    public static final ConfigEnabledCondition UNSTACKABLE_ALTS = ConfigEnabledCondition.add("unstackable_alts", Config.unstackableRecipeAlts);
    public static final ConfigEnabledCondition SKELETON_SKULL = ConfigEnabledCondition.add("skeleton_skull", Config.skeletonSkull);
    public static final ConfigEnabledCondition CAVE_SPIDER_WEB = ConfigEnabledCondition.add("cave_spider_web", Config.caveSpiderDrops);
    public static final ConfigEnabledCondition HEARTBEETS = ConfigEnabledCondition.add("heartbeets", Config.enableHeartbeet);
    public static final ConfigEnabledCondition CAULDRON_SOUPS = ConfigEnabledCondition.add("cauldron_soups", Config.enableCauldronSoups);
    public static final ConfigEnabledCondition CAULDRON_DYEING = ConfigEnabledCondition.add("cauldron_dyeing", Config.enableCauldronDyeing);
    public static final ConfigEnabledCondition EXTRA_BOTTLE_RECIPES = ConfigEnabledCondition.add("extra_bottle_recipes", Config.extraBottleRecipes);
    public static final ConfigEnabledCondition CAULDRON_POTIONS = ConfigEnabledCondition.add("cauldron_potions", Config.enableCauldronPotions);
    public static final ConfigEnabledCondition CAULDRON_BREWING = ConfigEnabledCondition.add("cauldron_brewing", Config.cauldronBrewing);

    private ConfigEnabledCondition(String configName, BooleanSupplier supplier) {
        this.configName = configName;
        this.supplier = supplier;
    }

    public ResourceLocation getID() {
        return ID;
    }

    public boolean test(ICondition.IContext context) {
        try {
            return this.supplier.getAsBoolean();
        }
        catch (Exception e) {
            Inspirations.log.error("Caught exception evaluating config condition {}", (Object)this.configName, (Object)e);
            throw e;
        }
    }

    public boolean test(LootContext lootContext) {
        return this.supplier.getAsBoolean();
    }

    public LootItemConditionType m_7940_() {
        return InspirationsCommons.lootConfig;
    }

    private static ConfigEnabledCondition add(String prop, BooleanSupplier supplier) {
        ConfigEnabledCondition conf = new ConfigEnabledCondition(prop, supplier);
        PROPS.put(prop.toLowerCase(Locale.ROOT), conf);
        return conf;
    }

    private static ConfigEnabledCondition add(String prop, ForgeConfigSpec.BooleanValue supplier) {
        return ConfigEnabledCondition.add(prop, () -> ((ForgeConfigSpec.BooleanValue)supplier).get());
    }

    public static class ConditionSerializer
    implements Serializer<ConfigEnabledCondition>,
    IConditionSerializer<ConfigEnabledCondition> {
        public ResourceLocation getID() {
            return ID;
        }

        public void write(JsonObject json, ConfigEnabledCondition value) {
            json.addProperty("prop", value.configName);
        }

        public ConfigEnabledCondition read(JsonObject json) {
            String prop = GsonHelper.m_13906_((JsonObject)json, (String)"prop");
            ConfigEnabledCondition config = PROPS.get(prop.toLowerCase(Locale.ROOT));
            if (config == null) {
                throw new JsonSyntaxException("Invalid property name '" + prop + "'");
            }
            return config;
        }

        public void serialize(JsonObject json, ConfigEnabledCondition condition, JsonSerializationContext context) {
            this.write(json, condition);
        }

        public ConfigEnabledCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            return this.read(json);
        }
    }
}

