/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons.data;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.BucketItem;
import slimeknights.mantle.data.GenericDataProvider;

public class FluidBucketModelProvider
extends GenericDataProvider {
    private final String modId;

    public FluidBucketModelProvider(DataGenerator generator, String modId) {
        super(generator, PackType.CLIENT_RESOURCES, "models/item");
        this.modId = modId;
    }

    private static JsonObject makeJson(BucketItem bucket) {
        JsonObject json = new JsonObject();
        json.addProperty("parent", "forge:item/bucket_drip");
        json.addProperty("loader", "forge:fluid_container");
        json.addProperty("flip_gas", Boolean.valueOf(bucket.getFluid().getFluidType().isLighterThanAir()));
        json.addProperty("fluid", Registry.f_122822_.m_7981_((Object)bucket.getFluid()).toString());
        return json;
    }

    public void m_213708_(CachedOutput cache) throws IOException {
        for (Map.Entry entry : Registry.f_122827_.m_6579_()) {
            Object v;
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            if (!id.m_135827_().equals(this.modId) || !((v = entry.getValue()) instanceof BucketItem)) continue;
            BucketItem bucket = (BucketItem)v;
            this.saveJson(cache, id, FluidBucketModelProvider.makeJson(bucket));
        }
    }

    public String m_6055_() {
        return this.modId + " Fluid Bucket Model Provider";
    }
}

