/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.cauldrons;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import knightminer.inspirations.Inspirations;
import knightminer.inspirations.cauldrons.block.BoilingFourLayerCauldronBlock;
import knightminer.inspirations.cauldrons.block.BoilingThreeLayerCauldronBlock;
import knightminer.inspirations.cauldrons.block.DyeCauldronBlock;
import knightminer.inspirations.cauldrons.block.FourLayerCauldronBlock;
import knightminer.inspirations.cauldrons.block.PotionCauldronBlock;
import knightminer.inspirations.cauldrons.block.SuspiciousStewCauldronBlock;
import knightminer.inspirations.cauldrons.block.entity.DyeCauldronBlockEntity;
import knightminer.inspirations.cauldrons.block.entity.PotionCauldronBlockEntity;
import knightminer.inspirations.cauldrons.block.entity.SuspiciousStewCauldronBlockEntity;
import knightminer.inspirations.cauldrons.data.FluidBlockstateModelProvider;
import knightminer.inspirations.cauldrons.data.FluidBucketModelProvider;
import knightminer.inspirations.cauldrons.data.FluidTextureProvider;
import knightminer.inspirations.cauldrons.data.RecipesRecipeProvider;
import knightminer.inspirations.cauldrons.interaction.DecreaseLayerCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.EmptyCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.FillCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.FirstCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.IncreaseLayerCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.TransformCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyeItemCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyeLeatherItemCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyeWaterCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyedBottleIntoDyeCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyedBottleIntoEmptyCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.DyedBottleIntoWaterCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.FillDyedBottleCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.MixDyeCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.dye.WaterBottleIntoDyeCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.potion.BrewingCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.potion.FillPotionCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.potion.PotionIntoEmptyInteraction;
import knightminer.inspirations.cauldrons.interaction.potion.PotionIntoPotionCauldron;
import knightminer.inspirations.cauldrons.interaction.potion.TipArrowCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.potion.WaterBottleIntoWaterInteraction;
import knightminer.inspirations.cauldrons.interaction.stew.DecreaseSuspiciousStewCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.stew.MixSuspiciousStewCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.stew.SuspiciousStewIntoEmptyCauldronInteraction;
import knightminer.inspirations.cauldrons.interaction.stew.SuspiciousStewingCauldronInteraction;
import knightminer.inspirations.cauldrons.item.EmptyBottleItem;
import knightminer.inspirations.cauldrons.item.MilkBottleItem;
import knightminer.inspirations.cauldrons.item.MixedDyedBottleItem;
import knightminer.inspirations.cauldrons.item.SimpleDyedBottleItem;
import knightminer.inspirations.cauldrons.recipe.BottleBrewingRecipe;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.ModuleBase;
import knightminer.inspirations.library.InspirationsTags;
import knightminer.inspirations.library.MiscUtil;
import knightminer.inspirations.library.recipe.cauldron.CauldronRegistry;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.CarpetedTrapdoorBlock;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BowlFoodItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import slimeknights.mantle.fluid.TextureFluidType;
import slimeknights.mantle.registration.FluidBuilder;
import slimeknights.mantle.registration.adapter.BlockEntityTypeRegistryAdapter;
import slimeknights.mantle.registration.adapter.BlockRegistryAdapter;
import slimeknights.mantle.registration.adapter.FluidRegistryAdapter;
import slimeknights.mantle.registration.adapter.ItemRegistryAdapter;
import slimeknights.mantle.registration.adapter.RegistryAdapter;
import slimeknights.mantle.registration.object.EnumObject;

public class InspirationsCaudrons
extends ModuleBase {
    public static final Map<Item, CauldronInteraction> MUSHROOM_STEW_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> BEETROOT_SOUP_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> RABBIT_STEW_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> POTATO_SOUP_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> HONEY_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> MILK_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> DYE_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> POTION_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static final Map<Item, CauldronInteraction> SUSPICIOUS_STEW_CAULDRON_INTERACTIONS = CauldronInteraction.m_175617_();
    public static FourLayerCauldronBlock mushroomStewCauldron;
    public static FourLayerCauldronBlock beetrootSoupCauldron;
    public static FourLayerCauldronBlock rabbitStewCauldron;
    public static FourLayerCauldronBlock potatoSoupCauldron;
    public static FourLayerCauldronBlock honeyCauldron;
    public static FourLayerCauldronBlock milkCauldron;
    public static FourLayerCauldronBlock suspiciousStewCauldron;
    public static LayeredCauldronBlock dyeCauldron;
    public static LayeredCauldronBlock potionCauldron;
    @Nullable
    private static LayeredCauldronBlock waterCauldron;
    public static BlockEntityType<DyeCauldronBlockEntity> dyeCauldronEntity;
    public static BlockEntityType<PotionCauldronBlockEntity> potionCauldronEntity;
    public static BlockEntityType<SuspiciousStewCauldronBlockEntity> suspiciousStewCauldronEntity;
    public static Item splashBottle;
    public static Item lingeringBottle;
    public static EnumObject<DyeColor, SimpleDyedBottleItem> simpleDyedWaterBottle;
    public static MixedDyedBottleItem mixedDyedWaterBottle;
    public static BowlFoodItem potatoSoupItem;
    public static Item milkBottle;
    public static FluidType mushroomStewType;
    public static ForgeFlowingFluid mushroomStew;
    public static BucketItem mushroomStewBucket;
    public static LiquidBlock mushroomStewBlock;
    public static FluidType beetrootSoupType;
    public static ForgeFlowingFluid beetrootSoup;
    public static BucketItem beetrootSoupBucket;
    public static LiquidBlock beetrootSoupBlock;
    public static FluidType rabbitStewType;
    public static ForgeFlowingFluid rabbitStew;
    public static BucketItem rabbitStewBucket;
    public static LiquidBlock rabbitStewBlock;
    public static FluidType potatoSoupType;
    public static ForgeFlowingFluid potatoSoup;
    public static BucketItem potatoSoupBucket;
    public static LiquidBlock potatoSoupBlock;
    public static FluidType honeyType;
    public static ForgeFlowingFluid honey;
    public static BucketItem honeyBucket;
    public static LiquidBlock honeyFluidBlock;
    public static SimpleParticleType boilingParticle;

    public InspirationsCaudrons() {
        ForgeMod.enableMilkFluid();
    }

    @SubscribeEvent
    void register(RegisterEvent event) {
        ResourceKey registryKey = event.getRegistryKey();
        if (registryKey == ForgeRegistries.Keys.FLUID_TYPES) {
            RegistryAdapter adapter = new RegistryAdapter((IForgeRegistry)ForgeRegistries.FLUID_TYPES.get());
            mushroomStewType = (FluidType)adapter.register((Object)new TextureFluidType(InspirationsCaudrons.fluidBuilder("mushroom_stew").temperature(373).viscosity(1200)), "mushroom_stew");
            beetrootSoupType = (FluidType)adapter.register((Object)new TextureFluidType(InspirationsCaudrons.fluidBuilder("beetroot_soup").temperature(373).viscosity(1100)), "beetroot_soup");
            rabbitStewType = (FluidType)adapter.register((Object)new TextureFluidType(InspirationsCaudrons.fluidBuilder("rabbit_stew").temperature(373).viscosity(1400)), "rabbit_stew");
            potatoSoupType = (FluidType)adapter.register((Object)new TextureFluidType(InspirationsCaudrons.fluidBuilder("potato_soup").temperature(373).viscosity(4000)), "potato_soup");
            honeyType = (FluidType)adapter.register((Object)new TextureFluidType(InspirationsCaudrons.fluidBuilder("honey").temperature(373).viscosity(4000)), "honey");
        } else if (registryKey == Registry.f_122899_) {
            FluidRegistryAdapter adapter = new FluidRegistryAdapter(ForgeRegistries.FLUIDS);
            mushroomStew = adapter.register(FluidBuilder.create(() -> mushroomStewType).block(() -> mushroomStewBlock).bucket(() -> mushroomStewBucket), "mushroom_stew");
            beetrootSoup = adapter.register(FluidBuilder.create(() -> beetrootSoupType).block(() -> beetrootSoupBlock).bucket(() -> beetrootSoupBucket), "beetroot_soup");
            rabbitStew = adapter.register(FluidBuilder.create(() -> rabbitStewType).block(() -> rabbitStewBlock).bucket(() -> rabbitStewBucket), "rabbit_stew");
            potatoSoup = adapter.register(FluidBuilder.create(() -> potatoSoupType).block(() -> potatoSoupBlock).bucket(() -> potatoSoupBucket), "potato_soup");
            honey = adapter.register(FluidBuilder.create(() -> honeyType).block(() -> honeyFluidBlock).bucket(() -> honeyBucket), "honey");
        } else if (registryKey == Registry.f_122901_) {
            BlockRegistryAdapter registry = new BlockRegistryAdapter(ForgeRegistries.BLOCKS);
            BlockBehaviour.Properties cauldronProps = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50256_);
            mushroomStewCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new BoilingFourLayerCauldronBlock(cauldronProps, MUSHROOM_STEW_CAULDRON_INTERACTIONS), "mushroom_stew_cauldron"));
            beetrootSoupCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new BoilingFourLayerCauldronBlock(cauldronProps, BEETROOT_SOUP_CAULDRON_INTERACTIONS), "beetroot_soup_cauldron"));
            rabbitStewCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new BoilingFourLayerCauldronBlock(cauldronProps, RABBIT_STEW_CAULDRON_INTERACTIONS), "rabbit_stew_cauldron"));
            potatoSoupCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new BoilingFourLayerCauldronBlock(cauldronProps, POTATO_SOUP_CAULDRON_INTERACTIONS), "potato_soup_cauldron"));
            honeyCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new FourLayerCauldronBlock(cauldronProps, HONEY_CAULDRON_INTERACTIONS), "honey_cauldron"));
            milkCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new BoilingFourLayerCauldronBlock(cauldronProps, MILK_CAULDRON_INTERACTIONS), "milk_cauldron"));
            mushroomStewBlock = registry.registerFluidBlock(() -> mushroomStew, Material.f_76305_, 0, "mushroom_stew");
            beetrootSoupBlock = registry.registerFluidBlock(() -> beetrootSoup, Material.f_76305_, 0, "beetroot_soup");
            rabbitStewBlock = registry.registerFluidBlock(() -> rabbitStew, Material.f_76305_, 0, "rabbit_stew");
            potatoSoupBlock = registry.registerFluidBlock(() -> potatoSoup, Material.f_76305_, 0, "potato_soup");
            honeyFluidBlock = registry.registerFluidBlock(() -> honey, Material.f_76305_, 0, "honey");
            dyeCauldron = (LayeredCauldronBlock)registry.register((Object)new DyeCauldronBlock(cauldronProps), "dye_cauldron");
            potionCauldron = (LayeredCauldronBlock)registry.register((Object)new PotionCauldronBlock(cauldronProps), "potion_cauldron");
            suspiciousStewCauldron = (FourLayerCauldronBlock)((Object)registry.register((Object)new SuspiciousStewCauldronBlock(cauldronProps), "suspicious_stew_cauldron"));
            if (Config.replaceVanillaCauldrons.getAsBoolean()) {
                waterCauldron = (LayeredCauldronBlock)registry.registerOverride(props -> new BoilingThreeLayerCauldronBlock((BlockBehaviour.Properties)props, LayeredCauldronBlock.f_153515_, CauldronInteraction.f_175607_), Blocks.f_152476_);
            }
        } else if (registryKey == Registry.f_122907_) {
            BlockEntityTypeRegistryAdapter registry = new BlockEntityTypeRegistryAdapter(ForgeRegistries.BLOCK_ENTITY_TYPES);
            dyeCauldronEntity = registry.register(DyeCauldronBlockEntity::new, (Block)dyeCauldron, "dye_cauldron");
            potionCauldronEntity = registry.register(PotionCauldronBlockEntity::new, (Block)potionCauldron, "potion_cauldron");
            suspiciousStewCauldronEntity = registry.register(SuspiciousStewCauldronBlockEntity::new, (Block)suspiciousStewCauldron, "suspicious_stew_cauldron");
        } else if (registryKey == Registry.f_122904_) {
            ItemRegistryAdapter registry = new ItemRegistryAdapter(ForgeRegistries.ITEMS);
            mushroomStewBucket = registry.registerBucket(() -> mushroomStew, "mushroom_stew");
            beetrootSoupBucket = registry.registerBucket(() -> beetrootSoup, "beetroot_soup");
            rabbitStewBucket = registry.registerBucket(() -> rabbitStew, "rabbit_stew");
            potatoSoupBucket = registry.registerBucket(() -> potatoSoup, "potato_soup");
            honeyBucket = registry.registerBucket(() -> honey, "honey");
            potatoSoupItem = (BowlFoodItem)registry.register((Object)new BowlFoodItem(new Item.Properties().m_41487_(1).m_41491_(CreativeModeTab.f_40755_).m_41489_(new FoodProperties.Builder().m_38760_(8).m_38758_(0.6f).m_38767_())), "potato_soup");
            Item.Properties brewingProps = new Item.Properties().m_41491_(CreativeModeTab.f_40758_);
            splashBottle = (Item)registry.register((Object)new EmptyBottleItem(brewingProps, () -> Items.f_42736_), "splash_bottle");
            lingeringBottle = (Item)registry.register((Object)new EmptyBottleItem(brewingProps, () -> Items.f_42739_), "lingering_bottle");
            milkBottle = (Item)registry.register((Object)new MilkBottleItem(new Item.Properties().m_41495_(Items.f_42590_).m_41491_(CreativeModeTab.f_40755_).m_41487_(16)), "milk_bottle");
            Item.Properties bottleProps = new Item.Properties().m_41491_(CreativeModeTab.f_40759_).m_41487_(16).m_41495_(Items.f_42590_);
            simpleDyedWaterBottle = registry.registerEnum(color -> new SimpleDyedBottleItem(bottleProps, DyeItem.m_41082_((DyeColor)color)), (Enum[])DyeColor.values(), "dyed_bottle");
            mixedDyedWaterBottle = (MixedDyedBottleItem)((Object)registry.register((Object)new MixedDyedBottleItem(bottleProps), "mixed_dyed_bottle"));
        } else if (registryKey == Registry.f_122906_) {
            RegistryAdapter registry = new RegistryAdapter(ForgeRegistries.PARTICLE_TYPES);
            boilingParticle = (SimpleParticleType)registry.register((Object)new SimpleParticleType(false), "boiling");
        }
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        gen.m_236039_(event.includeServer(), (DataProvider)new RecipesRecipeProvider(gen));
        boolean client = event.includeClient();
        gen.m_236039_(client, (DataProvider)new FluidBlockstateModelProvider(gen, "inspirations"));
        gen.m_236039_(client, (DataProvider)new FluidBucketModelProvider(gen, "inspirations"));
        gen.m_236039_(client, (DataProvider)new FluidTextureProvider(gen));
    }

    @SubscribeEvent
    void commonSetup(FMLCommonSetupEvent event) {
        ArrayList<AbstractCauldronBlock> allCauldrons = new ArrayList<AbstractCauldronBlock>();
        for (Block block : ForgeRegistries.BLOCKS) {
            if (!(block instanceof AbstractCauldronBlock)) continue;
            AbstractCauldronBlock cauldron = (AbstractCauldronBlock)block;
            allCauldrons.add(cauldron);
        }
        event.enqueueWork(() -> {
            BiConsumer<Item, CauldronInteraction> addToAll = (item, interaction) -> {
                for (AbstractCauldronBlock cauldron : allCauldrons) {
                    cauldron.f_151943_.put(item, interaction);
                }
            };
            if (Config.cauldronConcrete.getAsBoolean()) {
                DyeColor[] dyeColorArray = DyeColor.values();
                int n = dyeColorArray.length;
                for (int i = 0; i < n; ++i) {
                    DyeColor dye2 = dyeColorArray[i];
                    CauldronInteraction.f_175607_.put(InspirationsCaudrons.getConcretePowder(dye2).m_5456_(), new DecreaseLayerCauldronInteraction((ItemLike)InspirationsCaudrons.getConcrete(dye2), LayeredCauldronBlock.f_153514_));
                }
            }
            if (Config.cauldronCleanStickyPiston.getAsBoolean()) {
                CauldronInteraction.f_175607_.put(Items.f_41862_, new DecreaseLayerCauldronInteraction((ItemLike)Items.f_41869_, LayeredCauldronBlock.f_153514_, SoundEvents.f_11917_));
            }
            if (Config.cauldronWetSponge.getAsBoolean()) {
                EmptyCauldronInteraction spongeWet = new EmptyCauldronInteraction((ItemLike)Blocks.f_50057_, SoundEvents.f_11991_);
                CauldronInteraction.f_175607_.put(Items.f_41902_, spongeWet);
                DYE_CAULDRON_INTERACTIONS.put(Items.f_41902_, spongeWet);
            }
            if (Config.cauldronWashWool.getAsBoolean()) {
                InspirationsCaudrons.addToList(CauldronInteraction.f_175607_, new DecreaseLayerCauldronInteraction((ItemLike)Blocks.f_50041_, LayeredCauldronBlock.f_153514_), Items.f_41871_, Items.f_41872_, Items.f_41873_, Items.f_41874_, Items.f_41875_, Items.f_41876_, Items.f_41877_, Items.f_41878_, Items.f_41932_, Items.f_41933_, Items.f_41934_, Items.f_41935_, Items.f_41936_, Items.f_41937_, Items.f_41938_);
                InspirationsCaudrons.addToList(CauldronInteraction.f_175607_, new DecreaseLayerCauldronInteraction((ItemLike)Blocks.f_50066_, LayeredCauldronBlock.f_153514_), Items.f_42504_, Items.f_42505_, Items.f_42506_, Items.f_42507_, Items.f_42508_, Items.f_42509_, Items.f_42510_, Items.f_42511_, Items.f_42512_, Items.f_42513_, Items.f_42514_, Items.f_42568_, Items.f_42569_, Items.f_42570_, Items.f_42571_);
                InspirationsCaudrons.addToList(CauldronInteraction.f_175607_, new DecreaseLayerCauldronInteraction((ItemLike)Blocks.f_50336_, LayeredCauldronBlock.f_153514_), Items.f_42131_, Items.f_42132_, Items.f_42133_, Items.f_42134_, Items.f_42135_, Items.f_42136_, Items.f_42137_, Items.f_42138_, Items.f_42139_, Items.f_42140_, Items.f_42141_, Items.f_42142_, Items.f_42143_, Items.f_42197_, Items.f_42198_);
                InspirationsCaudrons.addToList(CauldronInteraction.f_175607_, new DecreaseLayerCauldronInteraction((ItemLike)InspirationsUtility.carpetedTrapdoors.get((Enum)DyeColor.WHITE), LayeredCauldronBlock.f_153514_), (Item[])Arrays.stream(DyeColor.values()).filter(dye -> dye != DyeColor.WHITE).map(color -> ((CarpetedTrapdoorBlock)InspirationsUtility.carpetedTrapdoors.get((Enum)color)).m_5456_()).toArray(Item[]::new));
                CauldronInteraction.f_175607_.put(InspirationsTools.dimensionCompass, CauldronInteraction.f_175615_);
            }
            if (Config.enableCauldronMilk.getAsBoolean()) {
                addToAll.accept(Items.f_42455_, new FillCauldronInteraction(milkCauldron));
                MILK_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)Items.f_42455_, SoundEvents.f_11781_));
                CauldronInteraction.f_175606_.put(milkBottle, new FillCauldronInteraction(milkCauldron, 1, (ItemLike)Items.f_42590_));
                MILK_CAULDRON_INTERACTIONS.put(milkBottle, IncreaseLayerCauldronInteraction.fourLevel((ItemLike)Items.f_42590_));
                MILK_CAULDRON_INTERACTIONS.put(Items.f_42590_, new DecreaseLayerCauldronInteraction((ItemLike)milkBottle, FourLayerCauldronBlock.LEVEL));
            }
            if (Config.enableCauldronHoney.getAsBoolean()) {
                FillCauldronInteraction fillHoney = new FillCauldronInteraction(honeyCauldron);
                addToAll.accept((Item)honeyBucket, fillHoney);
                CauldronRegistry.register(CauldronRegistry.ALL_CAULDRONS, CauldronRegistry.fluidTag(InspirationsTags.Fluids.HONEY), fillHoney);
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)honeyBucket, SoundEvents.f_11781_));
                CauldronInteraction.f_175606_.put(Items.f_42787_, new FillCauldronInteraction(honeyCauldron, 1, (ItemLike)Items.f_42590_));
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_42787_, IncreaseLayerCauldronInteraction.fourLevel((ItemLike)Items.f_42590_));
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_42590_, new DecreaseLayerCauldronInteraction((ItemLike)Items.f_42787_, FourLayerCauldronBlock.LEVEL));
                EmptyCauldronInteraction honeyToBlock = new EmptyCauldronInteraction((ItemLike)Blocks.f_50719_, false, SoundEvents.f_11964_);
                DecreaseLayerCauldronInteraction honeyToSugar = new DecreaseLayerCauldronInteraction(new ItemStack((ItemLike)Items.f_42501_, 3), FourLayerCauldronBlock.LEVEL, false, SoundEvents.f_11964_);
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_41852_, new FirstCauldronInteraction(honeyToBlock, honeyToSugar));
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_42788_, honeyToBlock);
                HONEY_CAULDRON_INTERACTIONS.put(Items.f_42501_, honeyToSugar);
                CauldronInteraction.f_175606_.put(Items.f_42788_, new FillCauldronInteraction(honeyCauldron, 4, (ItemLike)Items.f_41852_, SoundEvents.f_11967_));
            }
            if (Config.enableCauldronSoups.getAsBoolean()) {
                DyeColor[] fillMushroomStew = new FillCauldronInteraction(mushroomStewCauldron);
                addToAll.accept((Item)mushroomStewBucket, (CauldronInteraction)fillMushroomStew);
                CauldronRegistry.register(CauldronRegistry.ALL_CAULDRONS, CauldronRegistry.fluidTag(InspirationsTags.Fluids.MUSHROOM_STEW), (CauldronInteraction)fillMushroomStew);
                addToAll.accept((Item)potatoSoupBucket, new FillCauldronInteraction(potatoSoupCauldron));
                FillCauldronInteraction fillRabbitStew = new FillCauldronInteraction(rabbitStewCauldron);
                addToAll.accept((Item)rabbitStewBucket, fillRabbitStew);
                CauldronRegistry.register(CauldronRegistry.ALL_CAULDRONS, CauldronRegistry.fluidTag(InspirationsTags.Fluids.RABBIT_STEW), fillRabbitStew);
                FillCauldronInteraction fillBeetrootSoup = new FillCauldronInteraction(beetrootSoupCauldron);
                addToAll.accept((Item)beetrootSoupBucket, fillBeetrootSoup);
                CauldronRegistry.register(CauldronRegistry.ALL_CAULDRONS, CauldronRegistry.fluidTag(InspirationsTags.Fluids.BEETROOT_SOUP), fillBeetrootSoup);
                MUSHROOM_STEW_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)mushroomStewBucket, SoundEvents.f_11781_));
                POTATO_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)potatoSoupBucket, SoundEvents.f_11781_));
                RABBIT_STEW_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)rabbitStewBucket, SoundEvents.f_11781_));
                BEETROOT_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42446_, new EmptyCauldronInteraction((ItemLike)beetrootSoupBucket, SoundEvents.f_11781_));
                CauldronInteraction.f_175606_.put(Items.f_42400_, new FillCauldronInteraction(mushroomStewCauldron, 1, (ItemLike)Items.f_42399_));
                CauldronInteraction.f_175606_.put(potatoSoupItem, new FillCauldronInteraction(potatoSoupCauldron, 1, (ItemLike)Items.f_42399_));
                CauldronInteraction.f_175606_.put(Items.f_42699_, new FillCauldronInteraction(rabbitStewCauldron, 1, (ItemLike)Items.f_42399_));
                CauldronInteraction.f_175606_.put(Items.f_42734_, new FillCauldronInteraction(beetrootSoupCauldron, 1, (ItemLike)Items.f_42399_));
                IncreaseLayerCauldronInteraction increaseIntoBowl = IncreaseLayerCauldronInteraction.fourLevel((ItemLike)Items.f_42399_);
                MUSHROOM_STEW_CAULDRON_INTERACTIONS.put(Items.f_42400_, increaseIntoBowl);
                POTATO_SOUP_CAULDRON_INTERACTIONS.put((Item)potatoSoupItem, increaseIntoBowl);
                RABBIT_STEW_CAULDRON_INTERACTIONS.put(Items.f_42699_, increaseIntoBowl);
                BEETROOT_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42734_, increaseIntoBowl);
                MUSHROOM_STEW_CAULDRON_INTERACTIONS.put(Items.f_42399_, new DecreaseLayerCauldronInteraction((ItemLike)Items.f_42400_, FourLayerCauldronBlock.LEVEL));
                POTATO_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42399_, new DecreaseLayerCauldronInteraction((ItemLike)potatoSoupItem, FourLayerCauldronBlock.LEVEL));
                RABBIT_STEW_CAULDRON_INTERACTIONS.put(Items.f_42399_, new DecreaseLayerCauldronInteraction((ItemLike)Items.f_42699_, FourLayerCauldronBlock.LEVEL));
                BEETROOT_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42399_, new DecreaseLayerCauldronInteraction((ItemLike)Items.f_42734_, FourLayerCauldronBlock.LEVEL));
                if (Config.enableCauldronMilk.getAsBoolean()) {
                    mushroomTransform = new TransformCauldronInteraction(true, 2, FourLayerCauldronBlock.LEVEL, mushroomStewCauldron);
                    MILK_CAULDRON_INTERACTIONS.put(Items.f_41952_, mushroomTransform);
                    MILK_CAULDRON_INTERACTIONS.put(Items.f_41953_, mushroomTransform);
                    CauldronRegistry.register(CauldronRegistry.exactBlock((Block)milkCauldron), CauldronRegistry.itemTag((TagKey<Item>)Tags.Items.MUSHROOMS), mushroomTransform);
                } else {
                    mushroomTransform = new TransformCauldronInteraction(true, 2, LayeredCauldronBlock.f_153514_, mushroomStewCauldron);
                    CauldronInteraction.f_175607_.put(Items.f_41952_, mushroomTransform);
                    CauldronInteraction.f_175607_.put(Items.f_41953_, mushroomTransform);
                    CauldronRegistry.register(CauldronRegistry.exactBlock(Blocks.f_152476_), CauldronRegistry.itemTag((TagKey<Item>)Tags.Items.MUSHROOMS), mushroomTransform);
                }
                MUSHROOM_STEW_CAULDRON_INTERACTIONS.put(Items.f_42674_, new TransformCauldronInteraction(true, 2, FourLayerCauldronBlock.LEVEL, potatoSoupCauldron));
                POTATO_SOUP_CAULDRON_INTERACTIONS.put(Items.f_42698_, new TransformCauldronInteraction(true, 1, FourLayerCauldronBlock.LEVEL, rabbitStewCauldron));
                CauldronInteraction.f_175607_.put(Items.f_42732_, new TransformCauldronInteraction(true, 6, LayeredCauldronBlock.f_153514_, beetrootSoupCauldron));
                CauldronInteraction.f_175606_.put(Items.f_42718_, SuspiciousStewIntoEmptyCauldronInteraction.INSTANCE);
                SUSPICIOUS_STEW_CAULDRON_INTERACTIONS.put(Items.f_42399_, DecreaseSuspiciousStewCauldronInteraction.INSTANCE);
                SUSPICIOUS_STEW_CAULDRON_INTERACTIONS.put(Items.f_42718_, MixSuspiciousStewCauldronInteraction.INSTANCE);
                CauldronRegistry.register(CauldronRegistry.exactBlock((Block)mushroomStewCauldron), CauldronRegistry.itemTag((TagKey<Item>)ItemTags.f_13145_), SuspiciousStewingCauldronInteraction.INSTANCE);
            }
            if (Config.enableCauldronDyeing.getAsBoolean()) {
                for (DyeColor dye2 : DyeColor.values()) {
                    Item dyeItem = switch (dye2) {
                        default -> throw new IncompatibleClassChangeError();
                        case DyeColor.WHITE -> Items.f_42535_;
                        case DyeColor.ORANGE -> Items.f_42536_;
                        case DyeColor.MAGENTA -> Items.f_42537_;
                        case DyeColor.LIGHT_BLUE -> Items.f_42538_;
                        case DyeColor.YELLOW -> Items.f_42539_;
                        case DyeColor.LIME -> Items.f_42540_;
                        case DyeColor.PINK -> Items.f_42489_;
                        case DyeColor.GRAY -> Items.f_42490_;
                        case DyeColor.LIGHT_GRAY -> Items.f_42491_;
                        case DyeColor.CYAN -> Items.f_42492_;
                        case DyeColor.PURPLE -> Items.f_42493_;
                        case DyeColor.BLUE -> Items.f_42494_;
                        case DyeColor.BROWN -> Items.f_42495_;
                        case DyeColor.GREEN -> Items.f_42496_;
                        case DyeColor.RED -> Items.f_42497_;
                        case DyeColor.BLACK -> Items.f_42498_;
                    };
                    CauldronInteraction.f_175607_.put(dyeItem, new DyeWaterCauldronInteraction(dye2));
                    DYE_CAULDRON_INTERACTIONS.put(dyeItem, new MixDyeCauldronInteraction(dye2));
                    int color2 = MiscUtil.getColor(dye2);
                    CauldronInteraction.f_175606_.put((Item)simpleDyedWaterBottle.get((Enum)dye2), new DyedBottleIntoEmptyCauldronInteraction(color2));
                    CauldronInteraction.f_175607_.put((Item)simpleDyedWaterBottle.get((Enum)dye2), new DyedBottleIntoWaterCauldronInteraction(color2));
                    DYE_CAULDRON_INTERACTIONS.put((Item)simpleDyedWaterBottle.get((Enum)dye2), new DyedBottleIntoDyeCauldronInteraction(color2));
                }
                CauldronInteraction.f_175606_.put(mixedDyedWaterBottle, new DyedBottleIntoEmptyCauldronInteraction(null));
                CauldronInteraction.f_175607_.put(mixedDyedWaterBottle, new DyedBottleIntoWaterCauldronInteraction(null));
                DYE_CAULDRON_INTERACTIONS.put(mixedDyedWaterBottle, new DyedBottleIntoDyeCauldronInteraction(null));
                DYE_CAULDRON_INTERACTIONS.put(Items.f_42589_, new WaterBottleIntoDyeCauldronInteraction((ItemLike)Items.f_42590_, 0x808080));
                DYE_CAULDRON_INTERACTIONS.put(Items.f_42736_, new WaterBottleIntoDyeCauldronInteraction((ItemLike)splashBottle, 0x808080));
                DYE_CAULDRON_INTERACTIONS.put(Items.f_42739_, new WaterBottleIntoDyeCauldronInteraction((ItemLike)lingeringBottle, 0x808080));
                DYE_CAULDRON_INTERACTIONS.put(Items.f_42590_, FillDyedBottleCauldronInteraction.INSTANCE);
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, new DyeItemCauldronInteraction(color -> switch (color) {
                    default -> throw new IncompatibleClassChangeError();
                    case DyeColor.WHITE -> Items.f_41870_;
                    case DyeColor.ORANGE -> Items.f_41871_;
                    case DyeColor.MAGENTA -> Items.f_41872_;
                    case DyeColor.LIGHT_BLUE -> Items.f_41873_;
                    case DyeColor.YELLOW -> Items.f_41874_;
                    case DyeColor.LIME -> Items.f_41875_;
                    case DyeColor.PINK -> Items.f_41876_;
                    case DyeColor.GRAY -> Items.f_41877_;
                    case DyeColor.LIGHT_GRAY -> Items.f_41878_;
                    case DyeColor.CYAN -> Items.f_41932_;
                    case DyeColor.PURPLE -> Items.f_41933_;
                    case DyeColor.BLUE -> Items.f_41934_;
                    case DyeColor.BROWN -> Items.f_41935_;
                    case DyeColor.GREEN -> Items.f_41936_;
                    case DyeColor.RED -> Items.f_41937_;
                    case DyeColor.BLACK -> Items.f_41938_;
                }), Items.f_41870_, Items.f_41871_, Items.f_41872_, Items.f_41873_, Items.f_41874_, Items.f_41875_, Items.f_41876_, Items.f_41877_, Items.f_41878_, Items.f_41932_, Items.f_41933_, Items.f_41934_, Items.f_41935_, Items.f_41936_, Items.f_41937_, Items.f_41938_);
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, new DyeItemCauldronInteraction(color -> switch (color) {
                    default -> throw new IncompatibleClassChangeError();
                    case DyeColor.WHITE -> Items.f_42503_;
                    case DyeColor.ORANGE -> Items.f_42504_;
                    case DyeColor.MAGENTA -> Items.f_42505_;
                    case DyeColor.LIGHT_BLUE -> Items.f_42506_;
                    case DyeColor.YELLOW -> Items.f_42507_;
                    case DyeColor.LIME -> Items.f_42508_;
                    case DyeColor.PINK -> Items.f_42509_;
                    case DyeColor.GRAY -> Items.f_42510_;
                    case DyeColor.LIGHT_GRAY -> Items.f_42511_;
                    case DyeColor.CYAN -> Items.f_42512_;
                    case DyeColor.PURPLE -> Items.f_42513_;
                    case DyeColor.BLUE -> Items.f_42514_;
                    case DyeColor.BROWN -> Items.f_42568_;
                    case DyeColor.GREEN -> Items.f_42569_;
                    case DyeColor.RED -> Items.f_42570_;
                    case DyeColor.BLACK -> Items.f_42571_;
                }), Items.f_42503_, Items.f_42504_, Items.f_42505_, Items.f_42506_, Items.f_42507_, Items.f_42508_, Items.f_42509_, Items.f_42510_, Items.f_42511_, Items.f_42512_, Items.f_42513_, Items.f_42514_, Items.f_42568_, Items.f_42569_, Items.f_42570_, Items.f_42571_);
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, new DyeItemCauldronInteraction(color -> switch (color) {
                    default -> throw new IncompatibleClassChangeError();
                    case DyeColor.WHITE -> Items.f_42130_;
                    case DyeColor.ORANGE -> Items.f_42131_;
                    case DyeColor.MAGENTA -> Items.f_42132_;
                    case DyeColor.LIGHT_BLUE -> Items.f_42133_;
                    case DyeColor.YELLOW -> Items.f_42134_;
                    case DyeColor.LIME -> Items.f_42135_;
                    case DyeColor.PINK -> Items.f_42136_;
                    case DyeColor.GRAY -> Items.f_42137_;
                    case DyeColor.LIGHT_GRAY -> Items.f_42138_;
                    case DyeColor.CYAN -> Items.f_42139_;
                    case DyeColor.PURPLE -> Items.f_42140_;
                    case DyeColor.BLUE -> Items.f_42141_;
                    case DyeColor.BROWN -> Items.f_42142_;
                    case DyeColor.GREEN -> Items.f_42143_;
                    case DyeColor.RED -> Items.f_42197_;
                    case DyeColor.BLACK -> Items.f_42198_;
                }), Items.f_42130_, Items.f_42131_, Items.f_42132_, Items.f_42133_, Items.f_42134_, Items.f_42135_, Items.f_42136_, Items.f_42137_, Items.f_42138_, Items.f_42139_, Items.f_42140_, Items.f_42141_, Items.f_42142_, Items.f_42143_, Items.f_42197_, Items.f_42198_);
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, new DyeItemCauldronInteraction(dye -> (ItemLike)InspirationsUtility.carpetedTrapdoors.get((Enum)dye)), (Item[])InspirationsUtility.carpetedTrapdoors.values().stream().map(ItemLike::m_5456_).toArray(Item[]::new));
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, new DyeItemCauldronInteraction(color -> switch (color) {
                    default -> throw new IncompatibleClassChangeError();
                    case DyeColor.WHITE -> Items.f_42266_;
                    case DyeColor.ORANGE -> Items.f_42267_;
                    case DyeColor.MAGENTA -> Items.f_42268_;
                    case DyeColor.LIGHT_BLUE -> Items.f_42269_;
                    case DyeColor.YELLOW -> Items.f_42270_;
                    case DyeColor.LIME -> Items.f_42271_;
                    case DyeColor.PINK -> Items.f_42272_;
                    case DyeColor.GRAY -> Items.f_42273_;
                    case DyeColor.LIGHT_GRAY -> Items.f_42274_;
                    case DyeColor.CYAN -> Items.f_42275_;
                    case DyeColor.PURPLE -> Items.f_42224_;
                    case DyeColor.BLUE -> Items.f_42225_;
                    case DyeColor.BROWN -> Items.f_42226_;
                    case DyeColor.GREEN -> Items.f_42227_;
                    case DyeColor.RED -> Items.f_42228_;
                    case DyeColor.BLACK -> Items.f_42229_;
                }, true), Items.f_42266_, Items.f_42267_, Items.f_42268_, Items.f_42269_, Items.f_42270_, Items.f_42271_, Items.f_42272_, Items.f_42273_, Items.f_42274_, Items.f_42275_, Items.f_42224_, Items.f_42225_, Items.f_42226_, Items.f_42227_, Items.f_42228_, Items.f_42229_);
                InspirationsCaudrons.addToList(DYE_CAULDRON_INTERACTIONS, DyeLeatherItemCauldronInteraction.INSTANCE, (Item[])ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof DyeableLeatherItem).toArray(Item[]::new));
            }
            if (Config.enableCauldronPotions.getAsBoolean()) {
                if (Config.brewPotionBottles.getAsBoolean()) {
                    BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42590_}), Items.f_42589_, Items.f_42736_, new ItemStack((ItemLike)splashBottle)));
                    BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BottleBrewingRecipe(Ingredient.m_204132_(InspirationsTags.Items.SPLASH_BOTTLES), Items.f_42736_, Items.f_42739_, new ItemStack((ItemLike)lingeringBottle)));
                }
                POTION_CAULDRON_INTERACTIONS.put(Items.f_42590_, new FillPotionCauldronInteraction(Items.f_42589_));
                FillPotionCauldronInteraction fillSplashPotion = new FillPotionCauldronInteraction(Items.f_42736_);
                POTION_CAULDRON_INTERACTIONS.put(splashBottle, fillSplashPotion);
                CauldronRegistry.register(CauldronRegistry.exactBlock((Block)potionCauldron), CauldronRegistry.itemTag(InspirationsTags.Items.SPLASH_BOTTLES), fillSplashPotion);
                FillPotionCauldronInteraction fillLingeringBottle = new FillPotionCauldronInteraction(Items.f_42739_);
                POTION_CAULDRON_INTERACTIONS.put(lingeringBottle, fillLingeringBottle);
                CauldronRegistry.register(CauldronRegistry.exactBlock((Block)potionCauldron), CauldronRegistry.itemTag(InspirationsTags.Items.LINGERING_BOTTLES), fillLingeringBottle);
                POTION_CAULDRON_INTERACTIONS.put(Items.f_42589_, new PotionIntoPotionCauldron((ItemLike)Items.f_42590_));
                POTION_CAULDRON_INTERACTIONS.put(Items.f_42736_, new PotionIntoPotionCauldron((ItemLike)splashBottle));
                POTION_CAULDRON_INTERACTIONS.put(Items.f_42739_, new PotionIntoPotionCauldron((ItemLike)lingeringBottle));
                CauldronInteraction.f_175606_.put(Items.f_42589_, new PotionIntoEmptyInteraction((ItemLike)Items.f_42590_));
                CauldronInteraction.f_175606_.put(Items.f_42736_, new PotionIntoEmptyInteraction((ItemLike)splashBottle));
                CauldronInteraction.f_175606_.put(Items.f_42739_, new PotionIntoEmptyInteraction((ItemLike)lingeringBottle));
                CauldronInteraction.f_175607_.put(Items.f_42736_, new WaterBottleIntoWaterInteraction((ItemLike)splashBottle));
                CauldronInteraction.f_175607_.put(Items.f_42739_, new WaterBottleIntoWaterInteraction((ItemLike)lingeringBottle));
                CauldronInteraction.f_175607_.put(splashBottle, new DecreaseLayerCauldronInteraction(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42736_), (Potion)Potions.f_43599_), LayeredCauldronBlock.f_153514_, true, SoundEvents.f_11770_));
                CauldronInteraction.f_175607_.put(lingeringBottle, new DecreaseLayerCauldronInteraction(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42739_), (Potion)Potions.f_43599_), LayeredCauldronBlock.f_153514_, true, SoundEvents.f_11770_));
                if (Config.cauldronTipArrows.getAsBoolean()) {
                    POTION_CAULDRON_INTERACTIONS.put(Items.f_42412_, TipArrowCauldronInteraction.INSTANCE);
                }
                if (Config.cauldronBrewing.getAsBoolean()) {
                    CauldronRegistry.register(CauldronRegistry.exactBlock(Blocks.f_152476_), CauldronRegistry.ALL_ITEMS, new BrewingCauldronInteraction(Potions.f_43599_));
                    CauldronRegistry.register(CauldronRegistry.exactBlock((Block)potionCauldron), CauldronRegistry.ALL_ITEMS, new BrewingCauldronInteraction(null));
                }
            }
            Map map = GameData.getBlockStatePointOfInterestTypeMap();
            InspirationsCaudrons.register(map, (ResourceKey<PoiType>)PoiTypes.f_218054_, new Block[]{honeyCauldron, mushroomStewCauldron, potatoSoupCauldron, beetrootSoupCauldron, rabbitStewCauldron, dyeCauldron, potionCauldron, suspiciousStewCauldron, waterCauldron});
        });
    }

    private static void register(Map<BlockState, PoiType> map, ResourceKey<PoiType> key, Block ... blocks) {
        PoiType poi = (PoiType)ForgeRegistries.POI_TYPES.getValue(key.m_135782_());
        if (poi != null) {
            for (Block block : blocks) {
                if (block == null) continue;
                for (BlockState state : block.m_49965_().m_61056_()) {
                    map.put(state, poi);
                }
            }
        }
    }

    private static FluidType.Properties fluidBuilder(String name) {
        return FluidType.Properties.create().descriptionId(Util.m_137492_((String)"fluid", (ResourceLocation)Inspirations.getResource(name))).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11781_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11778_).motionScale(0.0023333333333333335).canExtinguish(true);
    }

    public static Block getConcretePowder(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50506_;
            case DyeColor.ORANGE -> Blocks.f_50507_;
            case DyeColor.MAGENTA -> Blocks.f_50508_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50509_;
            case DyeColor.YELLOW -> Blocks.f_50510_;
            case DyeColor.LIME -> Blocks.f_50511_;
            case DyeColor.PINK -> Blocks.f_50512_;
            case DyeColor.GRAY -> Blocks.f_50513_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50514_;
            case DyeColor.CYAN -> Blocks.f_50515_;
            case DyeColor.PURPLE -> Blocks.f_50516_;
            case DyeColor.BLUE -> Blocks.f_50517_;
            case DyeColor.BROWN -> Blocks.f_50518_;
            case DyeColor.GREEN -> Blocks.f_50519_;
            case DyeColor.RED -> Blocks.f_50573_;
            case DyeColor.BLACK -> Blocks.f_50574_;
        };
    }

    public static Block getConcrete(DyeColor color) {
        return switch (color) {
            default -> throw new IncompatibleClassChangeError();
            case DyeColor.WHITE -> Blocks.f_50542_;
            case DyeColor.ORANGE -> Blocks.f_50543_;
            case DyeColor.MAGENTA -> Blocks.f_50544_;
            case DyeColor.LIGHT_BLUE -> Blocks.f_50545_;
            case DyeColor.YELLOW -> Blocks.f_50494_;
            case DyeColor.LIME -> Blocks.f_50495_;
            case DyeColor.PINK -> Blocks.f_50496_;
            case DyeColor.GRAY -> Blocks.f_50497_;
            case DyeColor.LIGHT_GRAY -> Blocks.f_50498_;
            case DyeColor.CYAN -> Blocks.f_50499_;
            case DyeColor.PURPLE -> Blocks.f_50500_;
            case DyeColor.BLUE -> Blocks.f_50501_;
            case DyeColor.BROWN -> Blocks.f_50502_;
            case DyeColor.GREEN -> Blocks.f_50503_;
            case DyeColor.RED -> Blocks.f_50504_;
            case DyeColor.BLACK -> Blocks.f_50505_;
        };
    }

    private static void addToMapAndCauldron(Map<Item, CauldronInteraction> map, Item item, CauldronInteraction interaction) {
        map.put(item, interaction);
        CauldronInteraction.f_175606_.put(item, interaction);
    }

    private static void addToList(Map<Item, CauldronInteraction> map, CauldronInteraction interaction, Item ... items) {
        for (Item item : items) {
            map.put(item, interaction);
        }
    }

    static {
        simpleDyedWaterBottle = EnumObject.empty();
    }
}

