/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nullable;
import knightminer.inspirations.building.block.entity.ShelfBlockEntity;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.mantle.block.RetexturedBlock;

public class ShelfBlock
extends InventoryBlock
implements IHidable {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Map<Direction, VoxelShape> BOUNDS;

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ShelfBlockEntity(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        RetexturedBlock.updateTextureBlock((Level)world, (BlockPos)pos, (ItemStack)stack);
    }

    @Override
    public boolean isEnabled() {
        return Config.enableBookshelf.getAsBoolean();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.shouldAddtoItemGroup(group)) {
            super.m_49811_(group, items);
        }
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing.m_122424_() == trace.m_82434_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            return world.f_46443_ || this.openGui(player, world, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        Vec3 hitWorld = trace.m_82450_();
        Vec3 click = new Vec3(hitWorld.f_82479_ - (double)pos.m_123341_(), hitWorld.f_82480_ - (double)pos.m_123342_(), hitWorld.f_82481_ - (double)pos.m_123343_());
        if (!ShelfBlock.isBookClicked(facing, click)) {
            return world.f_46443_ || this.openGui(player, world, pos) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShelfBlockEntity) {
            if (((ShelfBlockEntity)te).interact(player, hand, click)) {
                return InteractionResult.SUCCESS;
            }
            if (hand != InteractionHand.OFF_HAND && !player.m_21206_().m_41619_()) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.CONSUME;
    }

    private static boolean isBookClicked(Direction facing, Vec3 click) {
        if (click.f_82480_ < 0.0625 || click.f_82480_ > 0.9375) {
            return false;
        }
        if (click.f_82480_ > 0.4375 && click.f_82480_ < 0.5625) {
            return false;
        }
        int offX = facing.m_122429_();
        int offZ = facing.m_122431_();
        double x1 = offX == -1 ? 0.625 : 0.0;
        double z1 = offZ == -1 ? 0.625 : 0.0;
        double x2 = offX == 1 ? 0.375 : 1.0;
        double z2 = offZ == 1 ? 0.375 : 1.0;
        return !(click.f_82479_ < x1 || click.f_82479_ > x2 || click.f_82481_ < z1 || click.f_82481_ > z2);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BOUNDS.get(state.m_61143_((Property)FACING));
    }

    @Deprecated
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShelfBlockEntity) {
            return ((ShelfBlockEntity)te).getComparatorPower();
        }
        return 0;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return RetexturedBlock.getPickBlock((BlockGetter)level, (BlockPos)pos, (BlockState)state);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader world, BlockPos pos) {
        if (!Config.bookshelvesBoostEnchanting.getAsBoolean()) {
            return 0.0f;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof ShelfBlockEntity) {
            return ((ShelfBlockEntity)te).getEnchantPower();
        }
        return 0.0f;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Direction side : Direction.Plane.HORIZONTAL) {
            int offX = side.m_122429_();
            int offZ = side.m_122431_();
            double x1 = offX == -1 ? 0.5 : 0.0;
            double z1 = offZ == -1 ? 0.5 : 0.0;
            double x2 = offX == 1 ? 0.5 : 1.0;
            double z2 = offZ == 1 ? 0.5 : 1.0;
            Vec3 first = new Vec3(-0.5, 0.0, -0.4375).m_82524_(-1.5707964f * (float)side.m_122416_());
            Vec3 second = new Vec3(0.5, 1.0, 0.0).m_82524_(-1.5707964f * (float)side.m_122416_());
            double minX = Math.min(first.f_82479_, second.f_82479_);
            double minZ = Math.min(first.f_82481_, second.f_82481_);
            double maxX = Math.max(first.f_82479_, second.f_82479_);
            double maxZ = Math.max(first.f_82481_, second.f_82481_);
            builder.put((Object)side, (Object)Shapes.m_83113_((VoxelShape)Shapes.m_83048_((double)x1, (double)0.0, (double)z1, (double)x2, (double)1.0, (double)z2), (VoxelShape)Shapes.m_83110_((VoxelShape)Shapes.m_83048_((double)(0.5 + minX), (double)0.0625, (double)(0.5 + minZ), (double)(0.5 + maxX), (double)0.4375, (double)(0.5 + maxZ)), (VoxelShape)Shapes.m_83048_((double)(0.5 + minX), (double)0.5625, (double)(0.5 + minZ), (double)(0.5 + maxX), (double)0.9375, (double)(0.5 + maxZ))), (BooleanOp)BooleanOp.f_82685_));
        }
        BOUNDS = builder.build();
    }
}

