/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import java.util.Locale;
import knightminer.inspirations.building.InspirationsBuilding;
import knightminer.inspirations.cauldrons.InspirationsCaudrons;
import knightminer.inspirations.common.CommonsClientEvents;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.InspirationsCommons;
import knightminer.inspirations.common.data.GlobalLootProvider;
import knightminer.inspirations.common.datagen.InspirationsBlockTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsFluidTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsItemTagsProvider;
import knightminer.inspirations.common.datagen.InspirationsLootTableProvider;
import knightminer.inspirations.common.network.InspirationsNetwork;
import knightminer.inspirations.tools.InspirationsTools;
import knightminer.inspirations.tweaks.InspirationsTweaks;
import knightminer.inspirations.utility.InspirationsUtility;
import net.minecraft.core.Registry;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.MissingMappingsEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.registration.RegistrationHelper;

@Mod(value="inspirations")
public class Inspirations {
    public static final String modID = "inspirations";
    public static final Logger log = LogManager.getLogger((String)"inspirations");

    public Inspirations() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.CLIENT_SPEC);
        log.info("Loading early config file...");
        CommentedFileConfig earlyConfig = (CommentedFileConfig)CommentedFileConfig.builder((Path)FMLPaths.CONFIGDIR.get().resolve("inspirations-common.toml")).sync().preserveInsertionOrder().writingMode(WritingMode.REPLACE).build();
        earlyConfig.load();
        earlyConfig.save();
        Config.COMMON_SPEC.setConfig((CommentedConfig)earlyConfig);
        log.info("Config loaded.");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.register((Object)this);
        modBus.register((Object)new InspirationsCommons());
        modBus.register((Object)new InspirationsBuilding());
        modBus.register((Object)new InspirationsUtility());
        modBus.register((Object)new InspirationsTools());
        modBus.register((Object)new InspirationsTweaks());
        modBus.register((Object)new InspirationsCaudrons());
        modBus.addListener(Config::configChanged);
        MinecraftForge.EVENT_BUS.register(Inspirations.class);
        MinecraftForge.EVENT_BUS.addListener(Inspirations::missingMappings);
        InspirationsNetwork.INSTANCE.setup();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CommonsClientEvents::onConstruct);
    }

    @SubscribeEvent
    void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        boolean server = event.includeServer();
        ExistingFileHelper existing = event.getExistingFileHelper();
        InspirationsBlockTagsProvider blockTags = new InspirationsBlockTagsProvider(gen, existing);
        gen.m_236039_(server, (DataProvider)blockTags);
        gen.m_236039_(server, (DataProvider)new InspirationsItemTagsProvider(gen, existing, blockTags));
        gen.m_236039_(server, (DataProvider)new InspirationsFluidTagsProvider(gen, existing));
        gen.m_236039_(server, (DataProvider)new InspirationsLootTableProvider(gen));
        gen.m_236039_(server, (DataProvider)new GlobalLootProvider(gen));
    }

    private static void missingMappings(MissingMappingsEvent event) {
        RegistrationHelper.handleMissingMappings((MissingMappingsEvent)event, (String)modID, (ResourceKey)Registry.f_122904_, name -> switch (name) {
            case "white_book", "orange_book", "magenta_book", "light_blue_book", "yellow_book", "lime_book", "pink_book", "gray_book", "light_gray_book", "cyan_book", "purple_book", "blue_book", "brown_book", "green_book", "red_book", "black_book" -> InspirationsBuilding.coloredBook;
            default -> null;
        });
    }

    public static ResourceLocation getResource(String name) {
        return new ResourceLocation(modID, name);
    }

    public static String resourceName(String name) {
        return String.format("%s:%s", modID, name.toLowerCase(Locale.US));
    }

    public static String prefix(String name) {
        return String.format("%s.%s", modID, name.toLowerCase(Locale.US));
    }
}

