/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.utility.block;

import javax.annotation.Nullable;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.IHidable;
import knightminer.inspirations.utility.InspirationsUtility;
import knightminer.inspirations.utility.block.entity.PipeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import slimeknights.mantle.block.InventoryBlock;
import slimeknights.mantle.util.BlockEntityHelper;

public class PipeBlock
extends InventoryBlock
implements IHidable,
SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    private static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    private static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    private static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    private static final BooleanProperty WEST = BlockStateProperties.f_61371_;
    private static final BooleanProperty UP = BlockStateProperties.f_61366_;
    private static final BooleanProperty DOWN = BlockStateProperties.f_61367_;
    public static final BooleanProperty HOPPER = BooleanProperty.m_61465_((String)"hopper");
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty[] DIR_ENABLED = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    private static final VoxelShape BOUNDS_CENTER = Shapes.m_83048_((double)0.375, (double)0.25, (double)0.375, (double)0.625, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_DOWN = Shapes.m_83048_((double)0.375, (double)0.0, (double)0.375, (double)0.625, (double)0.25, (double)0.625);
    private static final VoxelShape BOUNDS_UP = Shapes.m_83048_((double)0.375, (double)0.5, (double)0.375, (double)0.625, (double)1.0, (double)0.625);
    private static final VoxelShape BOUNDS_NORTH = Shapes.m_83048_((double)0.375, (double)0.25, (double)0.0, (double)0.625, (double)0.5, (double)0.375);
    private static final VoxelShape BOUNDS_SOUTH = Shapes.m_83048_((double)0.375, (double)0.25, (double)0.625, (double)0.625, (double)0.5, (double)1.0);
    private static final VoxelShape BOUNDS_WEST = Shapes.m_83048_((double)0.0, (double)0.25, (double)0.375, (double)0.375, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_EAST = Shapes.m_83048_((double)0.625, (double)0.25, (double)0.375, (double)1.0, (double)0.5, (double)0.625);
    private static final VoxelShape BOUNDS_DOWN_CONNECT = Shapes.m_83048_((double)0.34375, (double)0.0, (double)0.34375, (double)0.65625, (double)0.0625, (double)0.65625);
    private static final VoxelShape BOUNDS_UP_CONNECT = Shapes.m_83048_((double)0.34375, (double)0.9375, (double)0.34375, (double)0.65625, (double)1.0, (double)0.65625);
    private static final VoxelShape BOUNDS_NORTH_CONNECT = Shapes.m_83048_((double)0.34375, (double)0.21875, (double)0.0, (double)0.65625, (double)0.53125, (double)0.0625);
    private static final VoxelShape BOUNDS_SOUTH_CONNECT = Shapes.m_83048_((double)0.34375, (double)0.21875, (double)0.9375, (double)0.65625, (double)0.53125, (double)1.0);
    private static final VoxelShape BOUNDS_WEST_CONNECT = Shapes.m_83048_((double)0.0, (double)0.21875, (double)0.34375, (double)0.0625, (double)0.53125, (double)0.65625);
    private static final VoxelShape BOUNDS_EAST_CONNECT = Shapes.m_83048_((double)0.9375, (double)0.21875, (double)0.34375, (double)1.0, (double)0.53125, (double)0.65625);
    private static final VoxelShape[][] BOUNDS = new VoxelShape[6][64];

    public PipeBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76409_).m_60913_(3.0f, 8.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean isEnabled() {
        return Config.enablePipe.getAsBoolean();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> stacks) {
        if (this.shouldAddtoItemGroup(group)) {
            super.m_49811_(group, stacks);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, NORTH, EAST, SOUTH, WEST, UP, DOWN, HOPPER});
    }

    @Deprecated
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction neighFacing, BlockState neighState, LevelAccessor world, BlockPos pos, BlockPos neighPos) {
        Direction outFacing = (Direction)state.m_61143_((Property)FACING);
        state = (BlockState)state.m_61124_((Property)DIR_ENABLED[neighFacing.m_122411_()], (Comparable)Boolean.valueOf(PipeBlock.canConnectTo(world, pos, outFacing, neighFacing)));
        if (outFacing == neighFacing) {
            BlockState offsetState = world.m_8055_(pos.m_121945_(outFacing));
            state = (BlockState)state.m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(offsetState.m_60734_() instanceof HopperBlock && offsetState.m_61143_((Property)HopperBlock.f_54021_) != outFacing.m_122424_()));
        }
        return state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction facing = context.m_43719_().m_122424_();
        if (!((Boolean)Config.pipeUpwards.get()).booleanValue() && facing == Direction.UP) {
            facing = context.m_8125_();
        }
        BlockState offsetState = world.m_8055_(pos.m_121945_(facing));
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)HOPPER, (Comparable)Boolean.valueOf(offsetState.m_60734_() instanceof HopperBlock && offsetState.m_61143_((Property)HopperBlock.f_54021_) != facing.m_122424_()))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.NORTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.EAST)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(PipeBlock.canConnectTo((LevelAccessor)world, pos, facing, Direction.WEST)));
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        Item item = player.m_21120_(hand).m_41720_();
        if (item == InspirationsUtility.pipe.m_5456_() || Block.m_49814_((Item)item) instanceof HopperBlock) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, trace);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity te;
        if (state.m_60734_() != newState.m_60734_() && (te = world.m_7702_(pos)) instanceof Container) {
            Container container = (Container)te;
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)container);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    private static boolean canConnectTo(LevelAccessor world, BlockPos pos, Direction facing, Direction side) {
        if (facing == side) {
            return false;
        }
        BlockState state = world.m_8055_(pos.m_121945_(side));
        Block block = state.m_60734_();
        Direction opposite = side.m_122424_();
        if ((block instanceof PipeBlock || block instanceof DropperBlock) && state.m_61143_((Property)FACING) == opposite) {
            return true;
        }
        return side != Direction.DOWN && block instanceof HopperBlock && state.m_61143_((Property)HopperBlock.f_54021_) == opposite;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> matchType) {
        return BlockEntityHelper.serverTicker((Level)level, matchType, InspirationsUtility.tilePipe, PipeBlockEntity.SERVER_TICKER);
    }

    protected boolean openGui(Player player, Level world, BlockPos pos) {
        if (!(player instanceof ServerPlayer)) {
            throw new AssertionError((Object)"Needs to be server!");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)te;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)pipe, (BlockPos)pos);
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos neighbor, boolean isMoving) {
        BlockEntity te;
        if (pos.m_121945_((Direction)state.m_61143_((Property)FACING)).equals((Object)neighbor) && (te = world.m_7702_(pos)) instanceof PipeBlockEntity) {
            ((PipeBlockEntity)te).clearCachedInventories();
        }
        super.m_6861_(state, world, pos, blockIn, neighbor, isMoving);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        int bitmask = 0;
        for (int i = 0; i < 6; ++i) {
            bitmask |= (Boolean)state.m_61143_((Property)DIR_ENABLED[i]) != false ? 1 << i : 0;
        }
        return BOUNDS[((Direction)state.m_61143_((Property)FACING)).m_122411_()][bitmask];
    }

    static {
        VoxelShape[] BOUNDS_SIDES = new VoxelShape[]{BOUNDS_DOWN, BOUNDS_UP, BOUNDS_NORTH, BOUNDS_SOUTH, BOUNDS_WEST, BOUNDS_EAST};
        VoxelShape[] BOUNDS_CONN_SIDES = new VoxelShape[]{BOUNDS_DOWN_CONNECT, BOUNDS_UP_CONNECT, BOUNDS_NORTH_CONNECT, BOUNDS_SOUTH_CONNECT, BOUNDS_WEST_CONNECT, BOUNDS_EAST_CONNECT};
        for (int i = 0; i < 64; ++i) {
            int j;
            VoxelShape shape = BOUNDS_CENTER;
            for (j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                shape = Shapes.m_83124_((VoxelShape)shape, (VoxelShape[])new VoxelShape[]{BOUNDS_CONN_SIDES[j], BOUNDS_SIDES[j]});
            }
            for (j = 0; j < 6; ++j) {
                PipeBlock.BOUNDS[j][i] = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)BOUNDS_SIDES[j]);
            }
        }
    }
}

